<?php $__env->startSection('content'); ?>
<div class="content-wrapper">
  <?php echo $__env->make('layouts.includes.adminlte.alerts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <div class="card">
    <div class="card-body">
      <form class="form-sample"  role="form" method="POST" action="<?php echo e(route('admin.reports.renewal.show')); ?>" enctype="multipart/form-data">
        <?php echo e(csrf_field()); ?>

        <div class="row">
          <div class="col-md-6">
            <div class="form-group row">
              <label class="col-sm-3 col-form-label">Date From</label>
              <div class="col-sm-9">
                <input type="date" class="form-control " id="effective_date" name="effective_date" placeholder="" required="required"  value="<?php echo e($effective_date?? ''); ?>">
              </div>
            </div>
          </div>
          <div class="col-md-6">
            <div class="form-group row">
              <label class="col-sm-3 col-form-label">Date To</label>
              <div class="col-sm-9">
                <input type="date" class="form-control " id="expiration_date" name="expiration_date" placeholder="" required="required" value="<?php echo e($expiration_date?? ''); ?>">
                </div>
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-md-6">
            <div class="form-group row">
              <select class="form-control" onchange="display(this.value)">
                <option value="">Add more filter</option>
                <option value="branch">Branch</option>
                <option value="agency">Agency</option>
                <option value="policynum">Policy Number</option>
                <option value="policyclass">Policy Class</option>
                <option value="cloid">Clo Id</option>
                <option value="cloname">Clo Name</option>
              </select>
            </div>
          </div>
          <div class="col-md-6" id="searchby">
            
          </div>
        </div>
        <div class="row">
          <div class="col-lg-12 form-group  text-center">
            <input type="submit" class="btn btn-primary" name="search" value="Search">
            <a href="<?php echo e(route('admin.reports.renewal.show')); ?>" class="btn btn-success">Reset</a>
          </div>
        </div>
      </form>
      <h4 class="card-title">Policy Renewals</h4> Total Records </strong> <?php echo e(count($renewals)); ?><br/>
      <a type="button" onclick="getExport()" class="btn btn-info">Export</a>
      <script>
          function getExport(){
            let start_date = document.getElementById('effective_date').value
            let stop_date = document.getElementById('expiration_date').value
            let link = `/admin/reports/renewal/export?start_date=${start_date}&stop_date=${stop_date}`
            console.log(link)
            window.location.href= link
          }
      </script>
      <div class="row">
        <div class="col-12">
          <div class="table-responsive" style="overflow-x:auto;">
            <table id="order-listings" class="table">
              <thead>
                <tr>
                  
                  <th>Insured Name</th>
                  <th>Policy Type</th>
                  <th>Clo Name</th>
                  <th>Policy Number</th>
                  <th>Policy Premium</th>
                  <th>Effective Date</th>
                  <th>Policy Expire</th>
                  <th>Agency</th>
                  <th>Start Inception Date</th>
                  <th>Stop Inception Date</th>
                  
                </tr>
              </thead>
              <tbody>
                
                <?php $__currentLoopData = $renewals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $renewal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                
                <tr>
                  <td><?php echo e($renewal['customer_name']); ?></td>
                  <td><?php echo e($renewal['policy_type']); ?></td>
                  <td><?php echo e($renewal['clo_name']); ?></td>
                  <td><?php echo e($renewal['policy_number']); ?></td>
                  <td><?php echo e(number_format(abs(intval($renewal['sales_amount'])))); ?></td>
                  <td><?php echo e($renewal['effective_date']); ?></td>
                  <td><?php echo e($renewal['expiration_date']); ?></td>
                  <td><?php echo e($renewal['agency_name']); ?></td>
                  <td><?php echo e($renewal['start_insured_period']); ?></td>
                 <td><?php echo e($renewal['stop_insured_period']); ?></td>
                  <!-- policy no change instead of id -->
                  <!-- <td>
                    <div class="tools">
                      <a href="<?php echo e(route('admin.reports.renewal.details',$renewal['policy_number'])); ?>" title=" Policy Details"  class="confirmAction">
                        <i class="fa fa-bars"></i>
                      </a>
                      &nbsp;&nbsp;&nbsp;&nbsp;
                      <a type="button"  href="<?php echo e(route('admin.reports.renewal.export',$renewal['policy_number'])); ?>" title="Export Policy"  class="confirmAction">
                        <i class="fa fa-cloud-download"></i>
                      </a>
                      
                    </div>
                  </td> -->
                </tr>
                
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<script>
  function display(val){
    function getExport(){
      let start_date = document.getElementById('effective_date').value
      let stop_date = document.getElementById('expiration_date').value
      let link = `/admin/renewals/export?start_date=${start_date}&stop_date=${stop_date}`
      console.log(link)
      window.location.href= link
    }
    // document.getElementById('searchby').css('display','visible');
    if(val=="agency"){
      document.getElementById('searchby').innerHTML=`
        <div class="form-group row">
          <label class="col-sm-3 col-form-label">Agency</label>
          <div class="col-sm-9">
            <input type="text" class="form-control " id="agency" name="agency" value="<?php echo e($agent ?? ''); ?>">
          </div>
        </div>
      `
    }
    else if(val=="branch"){
      document.getElementById('searchby').innerHTML=`
            <div class="form-group row">
              <label class="col-sm-3 col-form-label">Branch</label>
              <div class="col-sm-9">
                <select class="form-control " id="branch" name="branch">
                 <option value="<?php echo e($branch ?? ''); ?>"><?php echo e($branch ?? 'select an option'); ?>/>
                  <option value="Lagos">Lagos Head Office Annex</option>
                  <option value="Abuja">Abuja Head office</option>
                  <option value="Onitsha">Onitsha</option>
                  <option value="Kaduna">Kaduna</option>
                  <option value="Port-Harcourt">Port-Harcourt</option>
                  <option value="Ibadan">Ibadan</option>
                  <option value="Bauchi">Bauchi</option>
                </select>
              </div>
            </div>
      `
    }
    else if(val=="policynum"){
      document.getElementById('searchby').innerHTML=`
        <div class="form-group row">
              <label class="col-sm-3 col-form-label">Policy Number</label>
              <div class="col-sm-9">
                <input type="text" class="form-control " id="pol_num" name="pol_num"   value="<?php echo e($pol_num ?? ''); ?>">
              </div>
            </div>
      `
    }
    else if(val=="policyclass"){
      document.getElementById('searchby').innerHTML=`
        <div class="form-group row">
              <label class="col-sm-3 col-form-label">Policy Class</label>
              <div class="col-sm-9">
                <input type="text" class="form-control " id="pol_class" name="pol_class"  value="<?php echo e($pol_class ?? ''); ?>">
              </div>
            </div>
      `
    }
    else if(val=="cloid"){
      document.getElementById('searchby').innerHTML=`
          <div class="form-group row">
              <label class="col-sm-3 col-form-label">Clo ID</label>
              <div class="col-sm-9">
                <input type="text" class="form-control " id="clo_id" name="clo_id"  value="<?php echo e($clo_id ?? ''); ?>">
              </div>
            </div>
      `
    }
    else if(val=="cloname"){
      document.getElementById('searchby').innerHTML=`
          <div class="form-group row">
              <label class="col-sm-3 col-form-label">Clo Name</label>
              <div class="col-sm-9">
                <input type="text" class="form-control " id="clo_name" name="clo_name"  value="<?php echo e($clo_name ?? ''); ?>">
              </div>
            </div>
      `
    }
    else{
      document.getElementById('searchby').innerHTML=`
      `
    }
  }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.includes.veritas.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/veritaskapital/veritaskapital.net/crm/resources/views/admin/reports/policy/index.blade.php ENDPATH**/ ?>