<?php $__env->startSection('content'); ?>
<div class="content-wrapper">
  <?php echo $__env->make('layouts.includes.adminlte.alerts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
   <div class="card">
    <div class="card-body">
      <div class="row">
        <div class="col-lg-8">
          <div class="template-demo">
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb bg-dark">
                <li class="breadcrumb-item"><a href="#">Reports</a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(route('teamLead.leads.show')); ?>">Leads</a></li>
              </ol>
            </nav>            
          </div>
        </div>
        <div class="col-lg-2">
          
          <a href="<?php echo e(route('teamLead.leads.import')); ?>" class="btn btn-inverse-success btn-fw float-right">Import</a>
        </div>
          <div class="col-lg-2">
           <a href="<?php echo e(route('teamLead.leads.create')); ?>" class="btn btn-inverse-success btn-fw float-right">Add  Lead</a>
        </div>
      </div>      
    </div>
  </div>

  <div class="card">
    <div class="card-body">
      <div class="row">
        <div class="col-12">
          <form class="form-sample"  role="form" method="POST" action="<?php echo e(route('teamLead.leads.show')); ?>" enctype="multipart/form-data">
            <?php echo e(csrf_field()); ?>

            <input type="hidden" name="search" value="true">
            <div class="row">
              <div class="col-md-6">
                <div class="form-group row">
                  <label class="col-sm-3 col-form-label">Date From</label>
                  <div class="col-sm-9">
                    <input type="date" class="form-control" id="start_dates" name="start_date" placeholder="" required="required"   value="<?php echo e($start_date ?? ''); ?>">
                  </div>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group row">
                  <label class="col-sm-3 col-form-label">Date To</label>
                  <div class="col-sm-9">
                    <input type="date" class="form-control" id="stop_dates" name="stop_date" placeholder="" required="required"   value="<?php echo e($stop_date ?? ''); ?>">
                    </div>
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-md-6">
            <div class="form-group row">
                <select class="form-control" onchange="display(this.value)">
                <option value="">Add more filter</option>
                <!-- <option value="branch">Branch</option>
                <option value="cloname">Clo Name</option> -->
                <option value="assigned_by">Assigned By</option>

              </select>
            </div>
          </div>
          <div class="col-md-6" id="searchby">
            
          </div>
        </div>

        <div class="row">
          <div class="col-lg-12 form-group  text-center">
            <input type="submit" class="btn btn-primary" name="search" value="Search">
            <a href="<?php echo e(route('teamLead.leads.show')); ?>" class="btn btn-success">Reset</a>
          </div>
        </div>
      </form>      
    </div>
  </div>

  <div class="card">
    <div class="card-body">
      <h4 class="card-title">Leads</h4>
      <a type="button" onclick="getExport()" class="btn btn-info">Export</a>
      <script>
        function getExport(){
            // admin/reports/sales/crm/export
            let start_date = document.getElementById('start_dates').value
            let stop_date = document.getElementById('stop_dates').value
            let link = `/admin/teamLead/leads/report/export?start_date=${start_date}&stop_date=${stop_date}`
            console.log(link)
            window.location.href= link
          }
      </script>
      <div class="row">
        <div class="col-12">
          <div class="table-responsive">
            <table id="order-listing" class="table">
               <thead>
                <tr>
                
                  <th>Assigned By</th>
                  <th>Name</th>
                  <th>Company</th>
                  <th>Company/Lead Type</th>
                  <th>Status</th>
                  <th>Action</th>
                 
                </tr>
              </thead>
              
                
                <?php $__currentLoopData = $leads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lead): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
               
              <tbody>
                <tr>
                  <td><?php echo e($lead->assigned_by_user_name); ?></td>
                  <td><?php echo e($lead->firstname); ?><?php echo e($lead->lastname); ?></td>
                  <td><?php echo e($lead->nature_of_organisation); ?></td>
                  <td><?php echo e($lead->lead_type); ?></td>
                  <td><?php echo e($lead->status); ?></td>
                  <td>
                    <?php if($lead->status != 'Sale'): ?>
                    <div class="tools">
                      <a href="<?php echo e(route('teamLead.leads.edit',$lead->id)); ?>" title="Edit Lead"   class="confirmAction">
                        <i class="fa fa-pencil"></i>
                      </a>
                      &nbsp;&nbsp;&nbsp;&nbsp;
                      <a onclick="showSwal(`<?php echo e(route('teamLead.leads.delete',['id'=>$lead->id])); ?>`)" href="#" title=" Lead Delete" deleteformid="form-3680" class="confirmAction">
                        <i class="fa fa-trash-o"></i>
                      </a>
                      
                    </div>
                    <?php endif; ?>
                  </td>
                </tr>
                
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.includes.veritas.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/veritaskapital/veritaskapital.net/crm/resources/views/admin/teamleads/index.blade.php ENDPATH**/ ?>