<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Performance Update</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            background-color: #f5f5f5;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
            background-color: #ffffff;
            border-radius: 5px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            animation: fadeIn 0.5s ease-out, backgroundColorChange 10s infinite alternate;
        }
        h1 {
            color: #333;
            animation: pulsate 1.5s infinite;
        }
        p {
            line-height: 1.6;
            color: #555;
        }
        ul {
            margin-left: 20px;
        }
        li {
            margin-bottom: 8px;
        }
        .signature {
            font-style: italic;
            margin-top: 20px;
            color: #888;
        }
        
        table {
            border-collapse: collapse;
            width: 100%;
            margin-top: 20px;
        }
     
        th, td {
            border: 1px solid #dddddd;
            padding: 10px;
            text-align: left;
            color: #333; /* Set default text color */
        }
     
        th {
            background-color: #303466;
            color: white; /* Set text color for th */
        }
     
        tr:hover {
            background-color: #62d438;
            color: white; /* Set text color for tr on hover */
        }

        /* Animation */
        @keyframes  fadeIn {
            0% {
                opacity: 0;
                transform: translateY(-10px);
            }
            100% {
                opacity: 1;
                transform: translateY(0);
            }
        }

        @keyframes  pulsate {
            0% {
                transform: scale(1);
            }
            50% {
                transform: scale(1.05);
            }
            100% {
                transform: scale(1);
            }
        }

        @keyframes  backgroundColorChange {
            0%, 100% {
                background-color: #ffffff;
            }
            50% {
                background-color: #f5f5f5;
            }
        }
    </style>
</head>
<body>
    <?php
        
        $remark = "";
        $production_color = "";
        $run_rate_color = "";
        
        if($run_rate >= 80){
            $remark = "Great job! You're making excellent progress towards your target.";
            $production_color = "#27ae60;";
            $run_rate_color = "#27ae60;";
        }elseif($run_rate >= 50){
            $remark = "You're steadily moving towards your target. Keep up the effort!";
            $production_color = "#3498db;";
            $run_rate_color = "#3498db;";
        }else{
            $remark = "Please put in extra effort to meet and exceed your target.";
            $production_color = "#e74c3c;";
            $run_rate_color = "#e74c3c;";
        }
    ?>
    
    
    <div class="container">
        <p style="text-align:center;"><img class="text-center" src="https://veritaskapital.com/image/catalog/certificate/uka-logo.png" width="auto" height="80"></p>
        <h2 style="text-align:center;">Branch Business Development Activities Summary</h2>
        <p>Dear Ma,</p>
        <p>Kindly find below summary of Branches Business Development activities for the past week:</p>

        <!--<p id="comment"> <?php echo e($remark); ?></p>-->
        <br/>
        <p>
            <h3>Branch Statistics</h3>

            <table>
                <thead>
                    <tr>
                        <th>Branch</th>
                        <th>Activities</th>
                        <th>Leads Generated</th>
                        <th>Opportunities Created</th>
                        <th>Sales Closed</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    if (count($branch_activities) > 0) {
                        foreach ($branch_activities as $record) {
                            echo "<tr>
                                    <td>$record->user_branch</td>
                                    <td style='text-center'>$record->calling_count</td>
                                    <td style='text-center'>$record->leads_count</td>
                                    <td style='text-center'>$record->opportunities_count</td>
                                    <td style='text-center'>$record->sales_count</td>
                                </tr>";
                        }
                    } else {
                        echo "<tr><td colspan='5'>No activity was recorded for this period</td></tr>";
                    }
                    ?>
                </tbody>
            </table>

        </p>
        <!--<p>Click <a href="https://enterprise.veritaskapital.net">HERE</a> to view more details</p>
        <p><i>For enquiries and/or clarifications, send an email to <a href="mailto:pms@veritaskapital.com">pms@veritaskapital.com</a></i></p>-->
        <br/>
        <p class="signature">Best regards,<br>CRM Team <br/>
            <!--<img src="https://veritaskapital.com/image/catalog/certificate/uka-logo.png" width="110" height="50">-->
        </p>
    </div>
</body>
</html>
<?php /**PATH /home/veritaskapital/veritaskapital.net/crm/resources/views/branch_activities_analytics_email_template.blade.php ENDPATH**/ ?>