<?php

namespace App\Http\Middleware;

use Closure;
use App\Models\Lead;
use App\Models\Task;
use Auth;
use App\Models\User;
use Session;
class Notifier
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $result = [];
        $today = date('Y-m-d');
        $leadnotifier = Lead::where('created_at','>=',$today)->where('user_id',Auth::user()->id)->where('notify_status','=',true)->count();
        $tasknotifier = Task::where('created_at','>=',$today)->where('user_id',Auth::user()->id)->where('notify_status','=',true)->count();
        Session::put('leadnotifier',$leadnotifier);
        Session::put('tasknotifier',$tasknotifier);
        // $request->session()->push(['' => ,''=>$]);
        return $next($request);
    }
}
