<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use Auth;

require base_path('vendor').'/phpmailer/phpmailer/src/Exception.php';
require base_path('vendor').'/phpmailer/phpmailer/src/PHPMailer.php';
require base_path('vendor').'/phpmailer/phpmailer/src/SMTP.php';



class PasswordPolicy extends Controller
{
    
    private $last_updated;
	private $current_date;
	private $reminder_intervals = [60, 83, 84, 85, 86, 87, 88, 89, 90];
	private $staff_id;
	private $staff_name;
	private $staff_email;
	private $con;
		
		
    /**
     * Create a new controller instance.
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
        $this->current_date = $this->getCurrentDate();
	    $this->con = $this->getConnection();
    }
    
    /**
     * View Change password view
     * @return view
     */
    public function view()
    {
        return view('change_password');
    }
    

    /** 
     * No Parameter required
     * return database connection
    **/ 
    private function getConnection()
	{
		// specify your own database credentials
		 
		$host = env('DB_HOST');
		$db_name = env('DB_DATABASE');
		$username = env('DB_USERNAME');
		$password = env('DB_PASSWORD');

		try{
			//$conn = new PDO("mysql:host=" . $host . ";dbname=" . $db_name, $username, $password);
			//$conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
			
			$conn = $conn = DB::connection()->getPdo();
			return $conn;
		}catch(PDOException $exception){
			die("Connection error: " . $exception->getMessage());
			die("<h2> Server Error. Contact Administrator</h2>");
		}
	}


	/** 
     * Email Address
     * return json response
    **/ 
	public function getUserLastDateChanged($email_address)
	{
		
		if(strlen($email_address) > 5){

	        try{

                $q = "SELECT * FROM tbl_password_policy WHERE user_email = '".$email_address."'";
                $pq = $this->con->prepare($q);
                $pq->execute();
                $c = $pq->rowCount();
                if($c > 0){
                	$stmt = $pq->fetchObject();
                	return json_encode(array("status" => "success", "message" => "success", "data" => $stmt));
		        }else{
		        	return json_encode(array("status" => "error", "message" => "User account not found"));
		        }
	        } catch (Exception $e) {
	            return json_encode(array("status" => "error", "message" => "Oops! Something went wrong.", "log" => "".$e->getMessage()));
	        }      

		}else{
			return json_encode(array("status" => "error", "message" => "Invalid Request"));
		}
	}


    /** 
     * No Parameter required
     * return the today's date
    **/ 
    public function getCurrentDate()
	{
		date_default_timezone_set('Africa/Lagos'); // Set the Default Time Zone:
	    //$date = '';
	    //$d = new DateTime($date);
	    //$cdate = $d->format('Y-m-d h:i:s'); 
	    $cdate = Carbon::now()->format('Y-m-d h:i:s');

	    return $cdate;
	}


	/** 
     * @param takes today's date and the last date password was changed
     * return in days the difference between the two dats
    **/
	public function dateDifference($today_date, $last_changed_date)
	{
		$date_now = strtotime($today_date); // or your date as well
		$last_changed_date = strtotime($last_changed_date);
		$datediff = $date_now - $last_changed_date;

		return round($datediff / (60 * 60 * 24));
	}


	/** 
     * @param a string to determine action to be performed (encrypt or decrypt) and the string to be encrypted.
     * return Either the encrypted strong or reverse the encrypted string to plain text.
    **/
	private function encrypt_decrypt($action, $string) 
	{
		$output = false;
		$encrypt_method = "AES-256-CBC";
		$secret_key = 'This is my secret key';
		$secret_iv = 'This is my secret iv';
		// hash
		$key = hash('sha256', $secret_key);

		// iv - encrypt method AES-256-CBC expects 16 bytes - else you will get a warning
		$iv = substr(hash('sha256', $secret_iv), 0, 16);
		if ( $action == 'encrypt' ) {
		    $output = openssl_encrypt($string, $encrypt_method, $key, 0, $iv);
		    $output = base64_encode($output);
		} else if( $action == 'decrypt' ) {
		    $output = openssl_decrypt(base64_decode($string), $encrypt_method, $key, 0, $iv);
		}
		return $output;
	}


	/** 
     * No Parameter required
     * return boolean true or false if date password was last changed exceeds 90-days
    **/ 
	public function isPasswordDueForChange($current_date, $last_updated)
	{
		$days = $this->dateDifference($current_date, $last_updated);

		if($days >= 90){
			return true;
		}

		return false;
	}


	/** 
     * @param user email addrees
     * return json response if email was sent tonprovided email address
    **/
	public function autoSendReminder($staff_email, $last_changed_date, $staff_id)
	{
		$days = $this->dateDifference($this->current_date, $last_changed_date);
		$url = "https://crm.veritaskapital.com/public/login";
		
		if(in_array($days, $this->reminder_intervals)){

			//$response = json_decode($this->sendEmail($staff_email, $url, 'reminder', $days));
			$response = json_decode($this->sendEmail($staff_email, $url, 'reminder', $days));

			if($response->status == "success"){
				return json_encode(array("status" => "success", "message" => "Reminder Successfully sent"));
			}else{
				return json_encode(array("status" => "error", "message" => "Error sending reminder ".$response->message));
			}				
		}

		return json_encode(array("status" => "N/A", "message" => "User not due for reminder"));
	}


	/** 
     * @param 
     * return
    **/
	public function sendEmail($email_address, $url, $email_type, $days)
	{
		$message = '';
		$subject = '';

		if($email_type == 'reminder'){
			$day = 90 - $days;
			$subject = "[REMINDER] Change your Password";
			$message = '<p>You password will be due for change in '.$day.' day(s). </p>';
			$message .= '<p> Click <a href="'.$url.'">HERE</a> to change your password. </p>.';
		}elseif($email_type == 'due'){
			$subject = "[CRM ACCOUNT SUSPENDED] Action Required";
			$message = '<p>You password is due for change</p>';
			$message .= '<p> Click <a href="'.$url.'">HERE</a> to change your password. </p>.';
		}

		$mail = new PHPMailer(true);

	    try
	    {
	        $mail->IsSMTP();
            $mail->SMTPDebug = 0;
            $mail->SMTPAuth = true;
            $mail->SMTPSecure = "tls";
            $mail->Port = 587;
            $mail->Username = "no_reply@veritaskapital.com";
            $mail->Password = "insurance@321";
            $mail->Host = "smtp.office365.com";
            $mail->SetFrom('no_reply@veritaskapital.com', 'Veritas Kapital Assurance');
            $mail->AddReplyTo($email_address, $email_address);
            $mail->AddAddress($email_address);
            $mail->Subject = ucwords($subject);
            $mail->WordWrap = 80;
            $mail->IsHTML(true);
            $mail->Body = $message;
			$mail->Debugoutput = function($str, $level) {echo "debug level $level; message: $str";}; 
			//$mail->Debugoutput = 'echo';

	        //$mail->MsgHTML($content);

	        if (!$mail->Send())
	        {
	            return json_encode(array("status" => "error", "message" => "Problem in sending mail."));
	        }
	        else
	        {
	        	return json_encode(array("status" => "success", "message" => "Email Successfully Sent"));
	        }

	    }
	    catch(phpmailerException $ep)
	    {
	        //echo $e->errorMessage(); //Pretty error messages from PHPMailer
	        return json_encode(array("status" => "error", "message" => "".$ep->errorMessage()));
	    }
	    catch(Exception $epp)
	    {
	        //echo $e->getMessage(); //Boring error messages from anything else!
	        return json_encode(array("status" => "error", "message" => "".$epp->getMessage()));
	    }
	}


	/** 
     * @param 
     * return 
    **/
	public function changePassword(Request $request)
	{
		$password = $request->input('old_password');
		$new_password = $request->input('new_password');
		$cnew_password = $request->input('cnew_password');
		$user_id = Auth::user()->id;
    		
		if(strlen($password) > 5 && strlen($new_password) > 5 && strlen($cnew_password) > 5 ){
		    
    		if($new_password === $cnew_password){
    
    	        $this->con->beginTransaction();
    
    	        try{
    
                    $q = "SELECT * FROM users WHERE id = '".$user_id."'";
                    $pq = $this->con->prepare($q);
                    $pq->execute();
                    $c = $pq->rowCount();
                    if($c > 0){
                    	$stmt = $pq->fetchObject();
                    	if(password_verify(trim($password), trim($stmt->password))){
    		            	$query = "UPDATE users
                                    SET 
                                        password = '".password_hash($cnew_password, PASSWORD_BCRYPT)."',
                                        updated_at = '".$this->current_date."'
                                    WHERE id = '".$user_id."'";
    
    	                    $stmt = $this->con->prepare($query);
    	                    $stmt->execute();
    	                    $stmt->closeCursor();
    
    	                    $query1 = "UPDATE tbl_password_policy
                                    SET 
                                        last_changed = '".$this->current_date."'
                                    WHERE user_id = '".$user_id."'";
    
    	                    $stmt1 = $this->con->prepare($query1);
    	                    $stmt1->execute();
    	                    $stmt1->closeCursor();
    
    	                    $this->con->commit();                    
    
    	                    return json_encode(array("status" => "success", "message" => "Password Successfully Updated"));
    		            }else{
    		            	return json_encode(array("status" => "error", "message" => "Incorrect Password Provided."));
    		            }
    		        }else{
    		        	return json_encode(array("status" => "error", "message" => "User account not found"));
    		        }
    
    	        } catch (Exception $e) {
    	            $this->con->rollBack();
    	            return json_encode(array("status" => "error", "message" => "Oops! Something went wrong.", "log" => "".$e->getMessage()));
    	        }      
    		}else{
    			return json_encode(array("status" => "error", "message" => "Your Password do not match"));
    		}
		}else{
		    return json_encode(array("status" => "error", "message" => "Please fill in all fields"));
		}
	}


	/** 
     * @param user password 
     * return boolean true if password is at least 8 characters in length and should include at least one 
     * upper case letter, one number, and one special character.
     * return false if password is weak
    **/
	public function checkPasswordStrength($password)
	{
		// Validate password strength
		$uppercase = preg_match('@[A-Z]@', $password);
		$lowercase = preg_match('@[a-z]@', $password);
		$number    = preg_match('@[0-9]@', $password);
		$specialChars = preg_match('@[^\w]@', $password);

		if(!$uppercase || !$lowercase || !$number || !$specialChars || strlen($password) < 8) {
		    return json_encode(array("status" => "error", "message" => "Password should be at least 8 characters in length and should include at least one upper case letter, one number, and one special character."));
		}else{
		    return json_encode(array("status" => "success", "message" => "Strong password."));
		}
	}


}
