<?php

namespace App\Http\Controllers\Customer;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Routing\Route;
use App\Http\Controllers\Controller;
use App\Models\Agent;
use App\Models\Customer;
use App\Models\User;
use Validator;
use Auth;

class CustomerController extends Controller
{
    
     public function dashboard() {
        $customers = Customer::count();
        $page_title  = 'Dashboard';
        return view('site/customer/dashboard', compact('customers','page_title'));
        
    }


    public function showProfile() {
    	$user = Customer::where('email','=',auth()->user()->email)->first(); 
        //dd($user);
        $page_title  = 'Customer Profile';
        return view('site/customer/profile', compact('user','page_title'));
        
    }


    public function profileUpdate(Request $request, $id) {
        
        $user = Customer::where('id', '=', $id)->first();
               
        $user->firstname = $request->name;
        $user->email = $request->email;

        $rules = $this->getRules($request, $user);

        if ($request->p1 != '' || $request->p2 != '') {
            if ($request->p1 != $request->p2) {
                $rules['password'] = 'required|min:6';
            }
        }
        $this->validate($request, $rules);

        if ($request->p1 != '' && $request->p2 != '') {
            if ($request->p1 == $request->p2) {
                $user->password = bcrypt($request->p1);
            }
        }
        if ($request->hasFile('image')) {
            $rules['image'] = 'image|mimes:png,jpg,gif,jpeg';
        }
        
        //$user->password = bcrypt($request->p1);       

       
        $user->save();

        if ($request->hasFile('image')) {
            $image = $request->file('image');
            $fileName = time() . "_customers_$user->id." . $image->getClientOriginalExtension();
            $image->move(public_path('uploads/site/customers/'), $fileName);

            if ($user->image != 'photo.jpg' && is_file(public_path('uploads/site/customers/' . $user->image))) {
                unlink(public_path('uploads/site/customers/' . $user->image));
            }
            $user->image = $fileName;
        }

        $user->save();

        return redirect()->route('customer.profile.showprofile')->with('success', 'Profile update successfully');

    }

     public function getRules(Request $request, $admin)
    {
        $rules = ['name' => 'required'];
//        $rules['name'] = 'required|unique';
        //       $rules['email'] = 'required|unique';
        if ($admin) {
            if ($request->email && $admin->email != $request->email) {
                $rules['email'] = 'unique:users';
            }
        } else {
            $rules['email'] = 'unique:users';
        }
        return $rules;
    }
}
