<?php

namespace App\Http\Controllers\Auth;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\PasswordPolicy;
//use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Support\Facades\Auth;



class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

     use AuthenticatesUsers {
    logout as performLogout;
}

    /**
     * Where to redirect users after login.
     *
     * @var string
     */

    protected $redirectTo = 'admin/dashboard';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
      
        $this->middleware('guest')->except('logout');
    }


    public function login(Request $request)
    {   
        $input = $request->all();
  
       $validator = $this->validate($request, [
            'username' => 'required',
            'password' => 'required',
        ]);


  
        $fieldType = filter_var($request->username, FILTER_VALIDATE_EMAIL) ? 'email' : 'username';
        

         if (Auth::attempt($validator)) {
             

            if(Auth::user()->status === 0){
                Auth::logout();
                return redirect()->route('login')->with('error','You are not active user, please contact admin.');
            }else{
                //Password policy check
                $user_email = $request->get('username');
                $password_policy = new PasswordPolicy();
            	$response_object = json_decode($password_policy->getUserLastDateChanged($user_email));
            
            	if($response_object->status == 'success'){
            		$user_info = $response_object->data;
            		$current_date = $password_policy->getCurrentDate();
            		$last_changed = $user_info->last_changed;
            		
            		$date_difference = $password_policy->dateDifference($current_date, $last_changed);
            
            		if($password_policy->isPasswordDueForChange($current_date, $last_changed)){
                        return redirect()->route('password.policy');
            		}else{
            			if($date_difference > 30){
            				$password_policy->autoSendReminder($user_email, $last_changed, Auth::user()->clo_id);
            				// /$day = 90 - $date_difference;
            				//echo "<script>alert('You have ".$day." day(s) left to change your password ');</script>";
            			}
            			
            			return redirect()->route('adminDashboard');
            		}
            	}else{
            		return back()->with('error', 'Error Encountered while verifying your credentials');
            	}
            	//end password policy check
            }
             
        }else{
            return redirect()->route('login')
                ->with('error','Invalid Credentials Provided');
        }
          
    }
   

   public function logout(Request $request)
    {
        $this->performLogout($request);
       return redirect()->route('login');
   }
}
