<?php

namespace App\Http\Controllers\Agent;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Customer;
use App\Models\User;
use App\Models\Service;
use Validator;
use DB;
use Auth;
use Image;

class ServiceController extends Controller
{
      public function index() {
    	$customers = Service::where('agent_id', '=', Auth::user()->id)->get();        
        $page_title  = 'Manage Service';
        return view('site/service/index', compact('customers','page_title'));
        
    }

     public function create(Request $request){ 
                
       $page_title = 'Add Service';
       $customers = Customer::get(); 
       return view('site/service/add', compact('page_title','customers'));    
      }

      public function store(Request $request){ 

      
      $Service = new Service;
      $Service->agent_id = Auth::user()->id;
      $Service->agent_name = Auth::user()->firstname.' '.Auth::user()->lastname;
      $Service->customer_id = $request->customer_id;
      $Service->customer_name = Customer::where('id', '=', $request->customer_id)->pluck('firstname')->first();      
      $Service->charges = $request->charges;
      $Service->bill_no = $request->bill_no;
       $Service->date = $request->date;
      $Service->remarks = $request->remarks;
      $Service->status = $request->get('status',0);

      $Service->save();
      return redirect()->route('agent.service.show')->with('success', 'Service Add Successfully.');

            
   }

     public function show($id) {
        $services = Service::where('id', '=', $id)->first();  
        $customers = Customer::get();       
        return view('site/service/edit', compact('services','customers'));    
    }

    public function update(Request $request, $id) {
      $Service = Service::where('id', '=', $id)->first();
      $Service->agent_id = Auth::user()->id;
      $Service->agent_name = Auth::user()->firstname.' '.Auth::user()->lastname;
      $Service->customer_id = $request->customer_id;
      $Service->customer_name = Customer::where('id', '=', $request->customer_id)->pluck('firstname')->first();      
      $Service->charges = $request->charges;
      $Service->bill_no = $request->bill_no;
       $Service->date = $request->date;
      $Service->remarks = $request->remarks;
      $Service->status = $request->get('status',0);
      $Service->save();

      return redirect()->route('agent.service.show')->with('success', 'Service Log Update Successfully .');
    }

   

     public function destroy($id) {
        $s = Service::find($id); 
        $s->delete(); //delete the User
        return redirect()->route('agent.service.show')->with('success', 'Service Log Delete Successfully.');
    }
}
