<?php

namespace App\Http\Controllers\Agent;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Customer;
use App\Models\User;
use App\Models\Service;
use App\Models\Activity;
use Validator;
use DB;
use Auth;
use Image;

class ActivityController extends Controller
{
     public function index(Request $request) {
      
      $customers = Customer::get(); 
       $responses = [
        '1'=>'Confirmed Appointment',
        '2'=>'Other'        
          ];

        if($request->search == 'true'){

          $activities = Activity::where('customer_id','=',$request->customer_id)
          ->where('response_id','=',$request->response_id)
          ->where('comment','=',$request->comment)
          ->where('appointment','=',$request->appointment)
          ->get();    

        }
        else{

    	   $activities = Activity::get();        
        }
        
        $page_title  = 'Manage Activity';
        return view('site/activity/index', compact('activities','page_title','customers','responses'));
        
    }

     public function create(Request $request){                 
       $page_title = 'Add Activity';
       $customers = Customer::get(); 
       $responses = [
       	'1'=>'Confirmed Appointment',
       	'2'=>'Other'       	
          ];
         
       return view('site/activity/add', compact('page_title','customers','responses'));    
      }

      public function store(Request $request){   
      
      $Activity = new Activity;
      $Activity->agent_id = Auth::user()->id;
      $Activity->agent_name = Auth::user()->firstname.' '.Auth::user()->lastname;
      $Activity->customer_id = $request->customer_id;
      $Activity->customer_name = Customer::where('id', '=', $request->customer_id)->pluck('firstname')->first();      
      $Activity->response_id = $request->response_id;
      $Activity->comment = $request->comment;
      $Activity->appointment = $request->appointment;
      $Activity->follow_up = $request->follow_up;
      $Activity->appointment_time = $request->appointment_time;
      $Activity->status = $request->get('status',0);
      
      $Activity->save();
      return redirect()->route('agent.activity.show')->with('success', 'Activity Log Add Successfully.');

            
   }

     public function show($id) {
        $responses = Activity::where('id', '=', $id)->first();  
        $customers = Customer::get(); 
       $activities = [
       	'1'=>'Confirmed Appointment',
       	'2'=>'Other'       	
          ];   
        return view('site/activity/edit', compact('responses','customers','activities'));    
    }

    public function update(Request $request, $id) {
     //dd($request);
      $Activity = Activity::where('id', '=', $id)->first();
      $Activity->agent_id = Auth::user()->id;
      $Activity->agent_name = Auth::user()->firstname.' '.Auth::user()->lastname;
      $Activity->customer_id = $request->customer_id;
      $Activity->customer_name = Customer::where('id', '=', $request->customer_id)->pluck('firstname')->first();      
      $Activity->response_id = $request->response_id;
      $Activity->comment = $request->comment;
      $Activity->appointment = $request->appointment;
      $Activity->follow_up = $request->follow_up;
      $Activity->appointment_time = $request->appointment_time;
      $Activity->status = $request->get('status',0);
      $Activity->save();
      return redirect()->route('agent.activity.show')->with('success', 'Activity Log Update Successfully .');
    }

   

     public function destroy($id) {
        $a = Activity::find($id); 
        $a->delete(); //delete the User
        return redirect()->route('agent.activity.show')->with('success', 'Activity Log Delete Successfully.');
    }
}
