<?php



namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Helpers\HeaderHelper;
use App\Mail\SendMail;
use App\Models\Staff;
use Validator;
use Image;



class StaffController extends Controller

{    

    public function index(Request $request){     
     $page_title = 'Staffs';
    
     $staffs = Staff::get();     
    return view('admin/staff/index', compact('page_title', 'staffs'));    
   }


    public function create(Request $request){ 
                
       $page_title = 'Add Staff';
       $states = HeaderHelper::states();
       return view('admin/staff/add', compact('page_title','states'));    
      }

     public function store(Request $request){ 
      //dd($request);
      $Staff = new Staff;
      
      $Staff->username = $request->username;
      $Staff->password = Hash::make($request->password);
      $Staff->firstname = $request->firstname;
      $Staff->lastname = $request->lastname;
      $Staff->email = $request->email;
      
      $Staff->phone = $request->phone_one;
      $Staff->address = $request->address;
      $Staff->city = $request->city;
      $Staff->state = $request->state;
      $Staff->postcode = $request->postcode;
      $Staff->status = $request->get('status',0);

      $Staff->save();

      if ($request->hasFile('image')) {
            $image = $request->file('image');
            $fileName = time() . "staff." . $image->getClientOriginalExtension();
            $image->move(public_path('uploads/site/staffs/'), $fileName);

            if ($Staff->image != 'photo.jpg' && is_file(public_path('uploads/site/staffs/' . $Staff->image))) {
                unlink(public_path('uploads/site/staffs/' . $Staff->image));
            }
            $Staff->image = $fileName;
            $Staff->save();
        }
       
     return redirect()->route('admin.staff.show')->with('success', 'Staff Add Successfully.');

            
   }

     public function show($id) {
        $staff = Staff::where('id', '=', $id)->first(); 
         $states = HeaderHelper::states();
        return view('admin/staff/edit', compact('staff','states'));    
    }

     public function update(Request $request, $id) {
      $Staff = Staff::where('id', '=', $id)->first();

       $Staff->username = $request->username;
      $Staff->password = Hash::make($request->password);
     
      $Staff->firstname = $request->firstname;
      $Staff->lastname = $request->lastname;
      $Staff->email = $request->email;
      
      $Staff->phone = $request->phone_one;
      $Staff->address = $request->address;
      $Staff->city = $request->city;
      $Staff->state = $request->state;
      $Staff->postcode = $request->postcode;
      $Staff->status = $request->get('status',0);

      $Staff->save();
      if ($request->hasFile('image')) {
            $image = $request->file('image');
            $fileName = time() . "staff." . $image->getClientOriginalExtension();
            $image->move(public_path('uploads/site/staffs/'), $fileName);

            if ($Staff->image != 'photo.jpg' && is_file(public_path('uploads/site/staffs/' . $Staff->image))) {
                unlink(public_path('uploads/site/staffs/' . $Staff->image));
            }
            $Staff->image = $fileName;
            $Staff->save();
        }            

      

    return redirect()->route('admin.staff.show')->with('success', 'Staff Update Successfully .');
    }
   

     public function destroy($id) {
        $c = Staff::find($id); 
        $c->delete();
        return redirect()->route('admin.staff.show')->with('success', 'Staff Delete Successfully.');
    }

    
    
    

}

