<?php



namespace App\Http\Controllers\Admin\Staff;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Helpers\HeaderHelper;
use App\Mail\SendMail;
use App\Models\Customer;
use App\Models\User;
use App\Models\Lead;
use App\Models\Insurance;
use Validator;
use Image;
use Auth;


class LeadController extends Controller

{    

    public function index(Request $request){     
    $page_title = 'Leads'; 
      $start_date = $request->start_date;
      $stop_date = $request->stop_date;   
    $assigned_by = $request->assigned_by;
    if($request->search == 'Search'){
      if(isset($request->assigned_by)){
        $leads = Lead::join('users', 'leads.user_id', '=', 'users.id')
              ->where('assigned_by_user_id','=',Auth::user()->id)
              ->whereBetween('leads.created_at',[$start_date, $stop_date])
              ->where('leads.assigned_by_user_name','like',"%{$assigned_by}%")
              ->select('leads.*','users.name as staffname')  
              ->get(); 
      }
      else{
        $leads = Lead::where('assigned_by_user_id','=',Auth::user()->id)
              ->join('users', 'leads.user_id', '=', 'users.id')
              ->whereBetween('leads.created_at',[$start_date, $stop_date])
              ->select('leads.*','users.name as staffname')  
              ->get(); 
      }
      
    }else{


    $leads = Lead::where('assigned_by_user_id','=',Auth::user()->id)
    ->join('users', 'leads.user_id', '=', 'users.id')
    ->select('leads.*','users.name as staffname')  
    ->get();  
    

    }
      // dd($leads);
    return view('admin/staff/index', compact('page_title', 'leads','start_date','stop_date','assigned_by'));    
   }

  public function assignedLeads(Request $request){     
    $page_title = 'Assigned Leads';    
     
    Lead::where('user_id','=',Auth::user()->id)->where('created_at','>=',date('Y-m-d'))->update(['notify_status'=>false]);
    $assigned_by = $request->assigned_by;
    $clo_name = $request->clo_name;
    $start_date = $request->start_date;
    $stop_date = $request->stop_date;
    if($request->search == 'Search'){
      
      if(isset($request->assigned_by)){
        $leads = Lead::where('user_id','=',Auth::user()->id)
                      ->whereBetween('leads.created_at',[$start_date, $stop_date])
                      ->where('assigned_by_user_name','like',"%{$request->assigned_by}%")
                      ->get(); 
      }else{
        $leads = Lead::where('user_id','=',Auth::user()->id)
                      ->whereBetween('leads.created_at',[$start_date, $stop_date])
                      ->get(); 
      }
    }
    else{
      $leads = Lead::where('user_id','=',Auth::user()->id)
               ->get(); 
    }
    return view('admin/staff/leads', compact('page_title', 'leads','assigned_by','start_date','stop_date'));    
   }


    public function create(Request $request){                 
       $page_title = 'Add Leads';
       $states   = HeaderHelper::states();
       $sources  = HeaderHelper::leadSource();
       $authID   = Auth::user()->id;
       $staffs = User::where('user_role', '=', 3)->get()->toArray();
       $insurances = Insurance::get();
       // /dd($staffs);
       return view('admin/staff/add', compact('page_title','states','sources','authID','staffs','insurances'));    
      }

     public function store(Request $request){ 
     
      $this->validate($request,[
            'contact_no' => 'min:11|numeric',
            
      ]);
      $Lead = new Lead;
      $Lead->user_id = $request->user_id;
      $Lead->type = 'staff';
      $Lead->assigned_by_user_id = Auth::user()->id;
      $Lead->user_role = User::where('id','=',$request->user_id)->pluck('user_role')->first();
      $Lead->assigned_by_user_name = Auth::user()->name.' '.Auth::user()->lastname;
      $Lead->firstname = $request->firstname;
      $Lead->lastname = $request->lastname;
      $Lead->email = $request->email;      
      $Lead->contact_no = $request->contact_no;
      //$Lead->clo_id = $request->clo_id;
        $Lead->clo_name = $request->clo_name;

      $Lead->address = $request->address;
      /*$Lead->city = $request->city;
      $Lead->state = $request->state;
      $Lead->post_code = $request->postcode;*/

      $Lead->lead_source = $request->lead_source;
      $Lead->lead_description = $request->lead_description;
      $Lead->lead_type = $request->lead_type;
      $Lead->orgnisation_type = $request->orgnisation_type;
      if($request->orgnisation_type  ==  'Company'){
        $Lead->nature_of_organisation = $request->nature_of_org_company;
      }else{
         $Lead->nature_of_organisation = $request->nature_of_org_individual;
      }
      $Lead->referred_by = $request->referred_by;
      
      $Lead->save();

     /* if ($request->hasFile('image')) {
            $image = $request->file('image');
            $fileName = time() . "lead." . $image->getClientOriginalExtension();
            $image->move(public_path('uploads/site/teamLead/leads'), $fileName);

            if ($Lead->image != 'photo.jpg' && is_file(public_path('uploads/site/teamLead/leads' . $Lead->image))) {
                unlink(public_path('uploads/site/teamLead/leads' . $Lead->image));
            }
            $Lead->image = 'uploads/site/teamLead/leads'.'/'.$fileName;
            $Lead->save();
        }*/

       
      return redirect()->route('staff.leads.show')->with('success', 'Lead Create Successfully.');

            
   }

     public function show($id) {
        $lead = Lead::where('id', '=', $id)->first(); 
        $states   = HeaderHelper::states();
        $sources  = HeaderHelper::leadSource();
        $authID   = Auth::user()->id;
        $staffs = User::where('user_role', '=', 3)->get()->toArray();
        $insurances = Insurance::get();
       // /dd($staffs);   
        return view('admin/staff/edit', compact('lead','states','sources','authID','staffs','insurances'));    
    }

     public function update(Request $request, $id) {
    // /dd($request);
      $this->validate($request,[
           'contact_no' => 'required|digits:11|numeric',
            
      ]);  
      $Lead = Lead::where('id', '=', $id)->first();    

      $Lead->user_id = $request->user_id;
      $Lead->type = 'staff';
      $Lead->assigned_by_user_id = Auth::user()->id;
      $Lead->user_role = User::where('id','=',$request->user_id)->pluck('user_role')->first();
      
      $Lead->assigned_by_user_name = Auth::user()->name.' '.Auth::user()->lastname;

      $Lead->firstname = $request->firstname;
      $Lead->lastname = $request->lastname;
      $Lead->email = $request->email;
     
      
      $Lead->contact_no = $request->contact_no;
      $Lead->address = $request->address;

      /*$Lead->city = $request->city;
      $Lead->state = $request->state;
      $Lead->post_code = $request->postcode;*/

      $Lead->lead_source = $request->lead_source;
      $Lead->lead_description = $request->lead_description;
      $Lead->lead_type = $request->lead_type;
      
      $Lead->orgnisation_type = $request->orgnisation_type;
      if($request->orgnisation_type  ==  'Company'){
        $Lead->nature_of_organisation = $request->nature_of_org_company;
      }else{
         $Lead->nature_of_organisation = $request->nature_of_org_individual;
      }
      $Lead->referred_by = $request->referred_by;

      $Lead->save();
      /*if ($request->hasFile('image')) {
            $image = $request->file('image');
            $fileName = time() . "lead." . $image->getClientOriginalExtension();
            $image->move(public_path('uploads/site/teamLead/leads'), $fileName);

            if ($Lead->image != 'photo.jpg' && is_file(public_path('uploads/site/teamLead/leads' . $Lead->image))) {
                unlink(public_path('uploads/site/teamLead/leads' . $Lead->image));
            }
            $Lead->image = 'uploads/site/teamLead/leads'.'/'.$fileName;
            $Lead->save();
        }  */          

      

    return redirect()->route('staff.leads.show')->with('success', 'Lead Update Successfully.');
    }

  

     public function destroy($id) {
        $c = Lead::find($id); 
        $c->delete();
        return redirect()->route('staff.leads.show')->with('success', 'Lead Delete Successfully.');
    }

      public function details($id) {
        $lead = Lead::where('id', '=', $id)->first(); 
        $insurances = Insurance::get();
        //dd($insurances);          
        return view('admin/staff/detail', compact('lead','insurances'));  
    }

      public function getCompanies(Request $request) {
        return $insurances = Insurance::where('name','like',$request->term.'%')->select('name')->first();
        //dd($insurances);     

        //return view('admin/staff/detail', compact('lead','insurances'));  
    }

    
    public function exportCsv(Request $request){
      $fileName = '';
      $leads = [];
      if($request->input('start_date')!==null && $request->input('stop_date')!==null){
        $fileName = 'leadsbtw-'.$request->input('start_date').'and'.$request->input('stop_date').'.csv';
        $leads =  Lead::where('assigned_by_user_id','=',Auth::user()->id)
          ->orWhere('leads.user_role','=',3)
          ->whereBetween('leads.created_at',[$request->input('start_date'),$request->input('stop_date')])
          ->join('users', 'leads.user_id', '=', 'users.id')
          ->select('leads.*','users.name as fullname')
          ->get();
      }
      else{
        $fileName = 'leads.csv';
        $leads =  Lead::where('assigned_by_user_id','=',Auth::user()->id)
        ->orWhere('leads.user_role','=',3)
        ->join('users', 'leads.user_id', '=', 'users.id')
        ->select('leads.*','users.name as fullname')
        ->get();
      }


   
        $headers = array(
            "Content-type"        => "text/csv",
            "Content-Disposition" => "attachment; filename=$fileName",
            "Pragma"              => "no-cache",
            "Cache-Control"       => "must-revalidate, post-check=0, pre-check=0",
            "Expires"             => "0"
        );

        $columns = array('Assigned By', 'Name', 'Email', 'Contact','Addess','City','Lead Type','Organisation Type','Referred by');

            $callback = function() use($leads, $columns) {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columns);

            foreach ($leads as $account) {
                $row['Assigned By']   = $account->assigned_by_user_name;
                $row['Name']     = $account->firstname.' '.$account->lastname;
                $row['Email']     = $account->email;
                $row['Contact']   = $account->contact_no;
                $row['Addess']       = $account->address;
                $row['City'] = $account->city;
                $row['Lead Type']   = $account->lead_type;
                $row['Organisation Type']  = $account->orgnisation_type;
                $row['Referred by']  = $account->referred_by;

                fputcsv($file, array($row['Assigned By'], $row['Name'], $row['Email'], $row['Contact'], $row['Addess'], $row['City'], $row['Lead Type'], $row['Organisation Type'],$row['Referred by']));
            }

            fclose($file);
        };

        
        
        return response()->stream($callback, 200, $headers);
    }

    

}

