<?php



namespace App\Http\Controllers\Admin\Staff;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Helpers\HeaderHelper;
use App\Helpers\UserHelper;
use App\Mail\SendMail;
use App\Models\Broker;
use App\Models\Contact;
use Validator;
use Image;
use Auth;



class ContactController extends Controller

{    

    public function index(Request $request){     
    $page_title = 'Contact';    
    $contacts = Contact::get();   
           
    return view('admin/staff/contact/index', compact('page_title','contacts'));    
   }


    
     public function exportCSV(Request $request){
      $fileName = 'activity.csv'; 
      $foundflag = false;
      $array     = [];
      $i         = 0;   
   

       $contacts = Contact::get();    
     
       $headers = array(
            "Content-type"        => "text/csv",
            "Content-Disposition" => "attachment; filename=$fileName",
            "Pragma"              => "no-cache",
            "Cache-Control"       => "must-revalidate, post-check=0, pre-check=0",
            "Expires"             => "0"
        );

           $columns = array('Name', 'Email', 'Gender');

            $callback = function() use($contacts, $columns) {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columns);

            foreach ($contacts as $contact) {
                
                $row['Name']          = $contact->name;
                $row['Email']         = $contact->email;
                $row['Gender']        = $contact->gender;
                
                
            fputcsv($file, array( $row['Name'], $row['Email'], $row['Gender']));
            }

            fclose($file);
        };

        
        
        return response()->stream($callback, 200, $headers);
    }
    
    

}

