<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Mail;
use App\Models\Customer;
use App\Mail\SendMail;
use Validator;



class SendEmailController extends Controller
{
    

   public function index(){ 
    
    return view('admin/emails/email');    

   }


   public function send(Request $request)   { 
       
    $this->validate($request,  [
    	 'name'      =>   'required',
    	 'email'     =>   'required|email',
    	 'message'   =>   'required'
    ]);
    
    $data = array(

       'name' => $request->name,
       'email' => $request->email,
       'message' => $request->message,

    );

  

    Mail::to($data['email'])->send(new SendMail($data));
    return back()->with('success','Thanks For Contacting Us!');
   }

   public function getCustomerList(){ 

     $customers = Customer::where('')->get();   
      return view('admin/emails/info_email_template_to_customer', compact('customers'));  

   }

    public function updatedInfoEmailToCustomer(){ 

     $customers = Customer::get();   
      return view('admin/emails/info_email_template_to_customer', compact('customers'));  

   }


   public function sendInfoEmail(Request $request)   { 
       
    $this->validate($request,  [
       'customer'  =>   'required',
       'name'      =>   'required',
       'email'     =>   'required|email',
       'message'   =>   'required'
    ]);
    
    $data = array(

       'customer' => $request->customer,
       'name' => $request->name,
       'email' => $request->email,
       'message' => $request->message,

    );

      $param = [
                'subject' => 'CRM: Customer Info',
                'from' => ['name' => env('MAIL_FROM_NAME'), 'address' => env('MAIL_FROM_ADDRESS')],
                'view' => 'templates/info_email_cutomer_template',
                'data' => $data
            ];

   

    Mail::to($data['email'])->send(new SendMail($param));
    return back()->with('success','Email Sent!');
   }


  
public function sendEmail(Request $request)   { 

 return view('admin/emails/mail');   
}

public function sendTestEmail(Request $request)   {

// /dd($request); 

 $this->validate($request,  [
       'subject'  =>   'required',
       'email'     =>   'required|email',
       'message'   =>   'required'
    ]);
    
    $data = array(

       'subject' => $request->subject,
       'email' => $request->email,
       'message' => $request->message,

    );

      $param = [
                'subject' => 'CRM: Customer Info',
                'from' => ['name' => env('MAIL_FROM_NAME'), 'address' => env('MAIL_FROM_ADDRESS')],
                'view' => 'templates/info_email_cutomer_template',
                'data' => $data
            ];

   

    Mail::to($data['email'])->send(new SendMail($param));
    return back()->with('success','Email Sent!');  
}


}
