<?php



namespace App\Http\Controllers\Admin\Reports;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Helpers\HeaderHelper;
use App\Mail\SendMail;
use App\Models\Sale;
use Validator;
use Image;
use GuzzleHttp\Client;


class SaleController extends Controller

{    

    public function index(Request $request){     
    $page_title = 'Sales Reports'; 
if($request->search == 'Search'){
   
    $client = new Client();
    $response = $client->request('POST', 'https://enterprise.veritaskapital.com/api/sales',[
    'form_params' => [
        'effective_date' => $request->effective_date,
        'expiration_date' => $request->expiration_date,
        'sum_insured' => $request->premium,
        'insured_name' => $request->insured_name,
        'branch' => $request->branch,
        'agent' => $request->agency,
        'pol_num' => $request->pol_num,
        'pol_class' => $request->pol_class,
        'clo_id' => $request->clo_id,
        'clo_name' => $request->clo_name,
        'cover_start' => $request->cover_start,
        'cover_end' => $request->cover_end,
      ]]);
          $statusCode = $response->getStatusCode();
          $sales = $response->getBody()->getContents();
          $sales = json_decode($sales);

          $effective_date = $request->effective_date;
          $expiration_date = $request->expiration_date;
          $premium = $request->premium;
          $insured_name = $request->insured_name;
          $branch = $request->branch;
          $agent = $request->agency;
          $pol_num = $request->pol_num;
          $pol_class = $request->pol_class;
          $clo_id = $request->clo_id;
          $clo_name = $request->clo_name;
          $cover_start = $request->cover_start;
          $cover_end = $request->cover_end;
    }
    else{
        $client = new Client();
        $response = $client->request('GET', 'https://enterprise.veritaskapital.com/api/sales');
        $statusCode = $response->getStatusCode();
        $sales = $response->getBody()->getContents();
        $sales = json_decode($sales);
        $effective_date = '';
        $expiration_date = '';
        $premium = '';
        $insured_name = '';
        $branch = '';
        $agent = '';
        $pol_num = '';
        $pol_class = '';
        $clo_id = '';
        $clo_name = '';
        $cover_start = '';
        $cover_end = '';
    }
    //dd($sales->data);
    return view('admin/reports/sales/index', compact('page_title', 'sales','effective_date','expiration_date','premium','insured_name','branch','agent','pol_num','pol_class','clo_id','clo_name','cover_start','cover_end'));    
   }


    public function create(Request $request){ 
       
      }

     public function store(Request $request){ 

      

            
   }

     public function show($id) {
       
    }

     public function update(Request $request, $id) {
      
    }


     public function destroy($id) {
       
    }
    public function exportCsv(Request $request){
      if($request->input('start_date')!==null && $request->input('stop_date')!==null){
        
        $fileName = 'Sales-'.$request->input('start_date').'to'.$request->input('stop_date').'.csv';
        $sales = $client = new Client();
        $response = $client->request('POST', 'https://enterprise.veritaskapital.com/api/sales',[
        'form_params' => [
            'effective_date' => $request->input('start_date'),
            'expiration_date' => $request->input('stop_date'),
          ]]);
          $statusCode = $response->getStatusCode();
          $sales = $response->getBody()->getContents();
          $sales = json_decode($sales);
          // dd("if",$sales->data);
          $headers = array(
              "Content-type"        => "text/csv",
              "Content-Disposition" => "attachment; filename=$fileName",
              "Pragma"              => "no-cache",
              "Cache-Control"       => "must-revalidate, post-check=0, pre-check=0",
              "Expires"             => "0"
          );

          $columns = array('Staff Name', 'Insured Name','Product','Policy Premium', 'Policy Number','Agency','Effective Date','Policy Expire');

              $callback = function() use($sales, $columns) {
              $file = fopen('php://output', 'w');
              fputcsv($file, $columns);

              foreach ($sales->data as $sale) {
                $row['Staff Name']           = $sale->clo_name;
                $row['Insured Name']         = $sale->customer_name;
                $row['Product']              = $sale->product_class;
                $row['Policy Premium']       = $sale->sales_amount;
                $row['Policy Number']        = $sale->policy_number;
                $row['Agency']               = $sale->agency_name;
                $row['Effective Date']       = $sale->effective_date;
                $row['Policy Expire']        = $sale->expiration_date;

                fputcsv($file, array( $row['Staff Name'], $row['Insured Name'],$row['Product'], $row['Policy Number'], $row['Policy Premium'], $row['Agency'],$row['Effective Date'],$row['Policy Expire']));
              }

              fclose($file);
          };
        }
        else{
            // dd("else",$request);
            $fileName = 'Sales.csv';
            $sales = $client = new Client();
            $response = $client->request('GET', 'https://enterprise.veritaskapital.com/api/sales');
            $statusCode = $response->getStatusCode();
            $sales = $response->getBody()->getContents();
            $sales = json_decode($sales);
            
            $headers = array(
                "Content-type"        => "text/csv",
                "Content-Disposition" => "attachment; filename=$fileName",
                "Pragma"              => "no-cache",
                "Cache-Control"       => "must-revalidate, post-check=0, pre-check=0",
                "Expires"             => "0"
            );
  
            $columns = array('Staff Name', 'Insured Name','Product','Policy Premium', 'Policy Number','Agency','Effective Date','Policy Expire');
  
                $callback = function() use($sales, $columns) {
                $file = fopen('php://output', 'w');
                fputcsv($file, $columns);
  
                foreach ($sales->data as $sale) {
                  $row['Staff Name']           = $sale->clo_name;
                  $row['Insured Name']         = $sale->customer_name;
                  $row['Product']              = $sale->product_class;
                  $row['Policy Premium']       = $sale->sales_amount;
                  $row['Policy Number']        = $sale->policy_number;
                  $row['Agency']               = $sale->agency_name;
                  $row['Effective Date']       = $sale->effective_date;
                  $row['Policy Expire']        = $sale->expiration_date;
  
                  fputcsv($file, array( $row['Staff Name'], $row['Insured Name'],$row['Product'], $row['Policy Number'], $row['Policy Premium'], $row['Agency'],$row['Effective Date'],$row['Policy Expire']));
                }
  
                fclose($file);
            };
        }
        
        
        return response()->stream($callback, 200, $headers);
    }

    public function exportCsv1(Request $request){
      if($request->input('start_date')!==null && $request->input('stop_date')!==null){
        $fileName = 'CRMSales-'.$request->input('start_date').'to'.$request->input('stop_date').'.csv';
        $sales = Sale::join('users','sales.user_id','=','users.id')->whereBetween('sales.created_at',[$request->input('start_date'),$request->input('stop_date')])->get();

    
          $headers = array(
              "Content-type"        => "text/csv",
              "Content-Disposition" => "attachment; filename=$fileName",
              "Pragma"              => "no-cache",
              "Cache-Control"       => "must-revalidate, post-check=0, pre-check=0",
              "Expires"             => "0"
          );

          $columns = array('Customer', 'Policy', 'Premium', 'Agency', 'Currency','Rate','Term','Cover From','Cover To','Policy Branch');

          $callback = function() use($sales, $columns) {
              $file = fopen('php://output', 'w');
              fputcsv($file, $columns);

              foreach ($sales as $sale) {
                  $row['Customer']   = $sale->name;
                  $row['Policy']     = $sale->insurance_name;
                  $row['Premium']    = $sale->price;
                  $row['Agency']     = $sale->agency;
                  $row['Currency']   = $sale->currency;
                  $row['Rate']       = $sale->rate;
                  $row['Cover From'] = $sale->cover_period_from;
                  $row['Cover To']   = $sale->cover_period_to;
                  $row['Policy Branch']  = $sale->insurance_branch;

                  fputcsv($file, array($row['Customer'], $row['Policy'], $row['Premium'], $row['Agency'], $row['Currency'], $row['Rate'], $row['Cover From'], $row['Cover To'], $row['Policy Branch']));
              }

              fclose($file);
          };
        }
        else{
          $fileName = 'CRMSales.csv';
          $sales = Sale::join('users','sales.user_id','=','users.id')->get();

      
            $headers = array(
                "Content-type"        => "text/csv",
                "Content-Disposition" => "attachment; filename=$fileName",
                "Pragma"              => "no-cache",
                "Cache-Control"       => "must-revalidate, post-check=0, pre-check=0",
                "Expires"             => "0"
            );

            $columns = array('Customer', 'Policy', 'Premium', 'Agency', 'Currency','Rate','Term','Cover From','Cover To','Policy Branch');

              $callback = function() use($sales, $columns) {
                $file = fopen('php://output', 'w');
                fputcsv($file, $columns);

                foreach ($sales as $sale) {
                    $row['Customer']   = $sale->name;
                    $row['Policy']     = $sale->insurance_name;
                    $row['Premium']    = $sale->price;
                    $row['Agency']     = $sale->agency;
                    $row['Currency']   = $sale->currency;
                    $row['Rate']       = $sale->rate;
                    $row['Cover From'] = $sale->cover_period_from;
                    $row['Cover To']   = $sale->cover_period_to;
                    $row['Policy Branch']  = $sale->insurance_branch;

                    fputcsv($file, array($row['Customer'], $row['Policy'], $row['Premium'], $row['Agency'], $row['Currency'], $row['Rate'], $row['Cover From'], $row['Cover To'], $row['Policy Branch']));
                }

                fclose($file);
            };
        }

        
        return response()->stream($callback, 200, $headers);
    }

  public function details($id){ 

    $page_title = 'Sales';    
    $sale = Sale::where('sales.id','=',$id)
    ->join('users as u1', 'u1.id', '=', 'sales.user_id')
    ->join('users as u2', 'u2.id', '=', 'sales.assigned_by_user_id')
    ->select('sales.*','u1.name as staffname','u2.name as teamleadname')
    ->first();
    //dd($sale);
    return view('admin/reports/sales/detail', compact('page_title', 'sale'));    
   }

   public function crmsales(Request $request){
     $page_title = "Sales Conversion";
      $insured_name = $request->insured_name;
      $pol_class = $request->pol_class;
      $clo_name = $request->clo_name;
      $agency = $request->agency;
      $branch = $request->branch;
      $effective_date = $request->effective_date;
      $expiration_date = $request->expiration_date;
     if($request->search == 'Search'){
      if(isset($request->branch)){
        $sales= Sale::join('users','users.id','=','sales.user_id')
                 ->select('sales.*','users.clo_id', 'users.name', 'sales.created_at as createdAt')  
                 ->whereBetween('sales.created_at',[$request->effective_date,$request->expiration_date])
                 ->where('sales.insurance_branch',$request->branch)->get();
      }
      elseif(isset($request->agency)){
        $sales= Sale::join('users','users.id','=','sales.user_id')
                 ->select('sales.*','users.clo_id', 'users.name', 'sales.created_at as createdAt')
                 ->whereBetween('sales.created_at',[$request->effective_date,$request->expiration_date])
                 ->where('sales.agency','LIKE',"%{$request->agency}%")->get();
      }
      elseif(isset($request->clo_name)){
        $sales= Sale::join('users','users.id','=','sales.user_id')
                 ->select('sales.*','users.clo_id', 'users.name', 'sales.created_at as createdAt') 
                 ->whereBetween('sales.created_at',[$request->effective_date,$request->expiration_date])
                 ->where(DB::raw('concat(users.firstname," ",users.lastname)'),'LIKE',"%{$request->clo_name}%")->get();
      }
      elseif(isset($request->pol_class)){
        $sales= Sale::join('users','users.id','=','sales.user_id')
                 ->select('sales.*','users.clo_id', 'users.name', 'sales.created_at as createdAt')
                 ->whereBetween('sales.created_at',[$request->effective_date,$request->expiration_date])
                 ->where('sales.insurance_name','LIKE',"%{$request->pol_class}%")->get();
      }
      elseif(isset($request->insured_name)){
        $sales= Sale::join('users','users.id','=','sales.user_id')
                  ->join('leads','leads.user_id','=','users.id')
                  ->select('sales.*','users.clo_id', 'users.name', 'sales.created_at as createdAt')
                 ->whereBetween('sales.created_at',[$request->effective_date,$request->expiration_date])
                 ->where(DB::raw('concat(leads.firstname," ",leads.lastname)'),'LIKE',"%{$request->insured_name}%")->get();
      }
      else{
        $sales= Sale::join('users','users.id','=','sales.user_id')
                  
                 ->whereBetween('sales.created_at',[$request->effective_date,$request->expiration_date])->get();
      }
    }
    else{
          
          $sales= Sale::join('users','users.id','=','sales.user_id')->select('sales.*','users.clo_id', 'users.name', 'sales.created_at as createdAt')->get();

    }

      return view('admin/reports/sales/crm',compact('page_title','sales','effective_date','expiration_date','insured_name','pol_class','clo_name','agency','branch'));
   }
    
    
    

}

