<?php

    namespace App\Http\Controllers\Admin\Reports;

    use App\Http\Controllers\Controller;
    use Illuminate\Support\Facades\Mail;
    use App\Mail\SendMail;
    use Illuminate\Support\Facades\DB;



    class ReportController extends Controller
    {    
        private $last_week_monday = '';
	    private $last_week_saturday = '';

        public function __construct()
        {
            $this-> last_week_monday = date('Y-m-d',strtotime('monday last week'));
	        $this->last_week_saturday = date('Y-m-d',strtotime('saturday last week'));

            //$this-> last_week_monday = '2021-01-01';
	        //$this->last_week_saturday = '2021-01-07';
        }

        public function sendWeeklyReport()
        {
            $results = DB::select("SELECT * FROM users WHERE address = 'BUSINESS DEVELOPMENT'");
            if(count($results) > 0){              
                //$i = 0;
                foreach ($results as $records) {
                    //if($i > 5){break;}
                    $this->weeklyAutoReport($records->id, $records->email, $records->lastname.' '.$records->name);
                    //$this->weeklyAutoReport($records->id, 'pbalarabe@veritaskapital.com', $records->lastname.' '.$records->name);
                    
                    //$i++;
                }
            }
        }

        private function weeklyAutoReport($user_id, $user_email, $user_name)
        {
            $data = array(
                'name' => ''.$user_name,
                'email' => ''.$user_email,
                'duration' => '  '.$this->last_week_monday.' to '.$this->last_week_saturday.'',
                'physical_call' => $this->getCallActivities($user_id, 'Physical'),
                'phone_call' => $this->getCallActivities($user_id, 'Call'),
                'leads_created' => $this->getLeadsCreated($user_id),
                'sales_made' => $this->getSalesMade($user_id),
                'opportunities_created' => $this->getOpportunitiesCreated($user_id),
                'last_usage' => $this->getLastDateOfUsage($user_id)
            );
            //'vka_rides' => $this->getVkaRidesCreated($user_id),
            $param = [
                'subject' =>'CRM Weekly Report for '.$this->last_week_monday.' - '.$this->last_week_saturday,
                'from' => ['name' => 'CRM Weekly Report ', 'address' => 'no_reply@veritaskapital.com'],
                'view' => 'templates/crm_weekly_report',
                'name' => 'CRM Weekly Report',
                'address' =>  'no_reply@veritaskapital.com',
                'data' => $data
            ];

           Mail::to($user_email)->bcc('ailiyasu@veritaskapital.com')->send(new SendMail($param));
        }
        
        public function testCronJob()
        {
            $data = array(
                'name' => '',
                'email' => '',
                'duration' => '  '.$this->last_week_monday.' to '.$this->last_week_saturday.'',
                'physical_call' => 0,
                'phone_call' => 0,
                'leads_created' => 0,
                'sales_made' => 0,
                'opportunities_created' => 0,
                'last_usage' => 0
            );
            
            $param = [
                'subject' =>'CRM Weekly Report for '.$this->last_week_monday.' - '.$this->last_week_saturday,
                'from' => ['name' => 'CRM Weekly Report ', 'address' => 'no_reply@veritaskapital.com'],
                'view' => 'templates/crm_weekly_report',
                'name' => 'CRM Weekly Report',
                'address' =>  'no_reply@veritaskapital.com',
                'data' => $data
            ];

           Mail::to('aisa@veritaskapital.com')->bcc('pbalarabe@veritaskapital.com')->send(new SendMail($param));
        }

        private function getCallActivities($user_id, $mode_of_activity)
        {
            $total = 0;

            $results = DB::select("SELECT COUNT(*) AS total FROM callings WHERE user_id = '".$user_id."' AND mode_of_activity = '".$mode_of_activity."' AND DATE(created_at) BETWEEN '".$this->last_week_monday."' AND '".$this->last_week_saturday."' group by week(created_at)");
            if(count($results) > 0){
                $total = $results[0]->total;
            }
            //dd($results);
            return $total;
        }

        private function getVkaRidesCreated()
        {
            return '0';
        }

        private function getLeadsCreated($user_id)
        {
            $total = '0';

            $results = DB::select("SELECT COUNT(*) AS total, user_id, created_at FROM leads WHERE user_id = '".$user_id."' AND DATE(created_at) BETWEEN '".$this->last_week_monday."' AND '".$this->last_week_saturday."' group by week(created_at)");
            if(count($results) > 0){
                 $total = $results[0]->total;
            }

            return $total;
        }

        private function getSalesMade($user_id)
        {
            $total = 0;

             $results = DB::select("SELECT COUNT(*) AS total, user_id, created_at FROM sales WHERE user_id = '".$user_id."' AND DATE(created_at) BETWEEN '".$this->last_week_monday."' AND '".$this->last_week_saturday."' group by week(created_at)");
            if(count($results) > 0){
                 $total = $results[0]->total;
            }

            return $total;
        }

        private function getOpportunitiesCreated($user_id)
        {
            $total = '0';

             $results = DB::select("SELECT COUNT(*) AS total, user_id, created_at FROM opportunities WHERE user_id = '".$user_id."' AND DATE(created_at) BETWEEN '".$this->last_week_monday."' AND '".$this->last_week_saturday."' group by week(created_at)");
            if(count($results) > 0){
                 $total = $results[0]->total;
            }

            return $total;
        }

        private function getLastDateOfUsage($user_id)
        {
            $last_date = '0';

            $results = DB::table('callings')->where('user_id', $user_id)->latest('created_at')->first();
            if($results){
                $last_date = $results->created_at;
            }

            return $last_date;
        }
    }

?>