<?php



namespace App\Http\Controllers\Admin\Reports;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Helpers\HeaderHelper;
use App\Mail\SendMail;
use App\Models\Customer;
use App\Models\Lead;
use App\Models\User;
use Validator;
use Image;



class CustomerController extends Controller

{    

    public function index(Request $request){     
    $page_title = 'Customers';    

    $customers = Customer::get();  
        
    return view('admin/reports/customers/index', compact('page_title', 'customers'));    
   }


    public function create(Request $request){ 
                
       $page_title = 'Add Customer';
       $states = HeaderHelper::states();
       return view('admin/reports/customers/add', compact('page_title','states'));    
      }

     public function store(Request $request){ 

      $Customer = new Customer;
      $Customer->username = $request->username;
      $Customer->firstname = $request->firstname;
      $Customer->lastname = $request->lastname;
      $Customer->email = $request->email;
      $Customer->password = Hash::make($request->password);
      $Customer->phone_one = $request->phone_one;
      $Customer->phone_two = $request->phone_two;
      $Customer->phone_three = $request->phone_three;

      $Customer->address_one = $request->address_one;
      $Customer->address_two = $request->address_two;
      $Customer->address_three = $request->address_three;
      $Customer->address_four = $request->address_four;

      $Customer->area = $request->area;
      $Customer->state = $request->state;
      $Customer->postcode = $request->postcode;
      $Customer->models = $request->models;
      $Customer->serial_no = $request->serial_no;
      $Customer->remarks = $request->remarks;
      $Customer->purchase_date = $request->purchase_date;
      $Customer->status = $request->get('status',0);

      $Customer->save();

      if ($request->hasFile('image')) {
            $image = $request->file('image');
            $fileName = time() . "customer." . $image->getClientOriginalExtension();
            $image->move(public_path('uploads/site/customers/'), $fileName);

            if ($Customer->image != 'photo.jpg' && is_file(public_path('uploads/site/customers/' . $Customer->image))) {
                unlink(public_path('uploads/site/customers/' . $Customer->image));
            }
            $Customer->image = $fileName;
            $Customer->save();
        }

        $data = array(

       'name' => $request->firstname.' '.$request->lastname,
       'email' => $request->email,
       'username' => $request->username,
       'password' => $request->password       

    );

          $param = [
                'subject' => 'CRM: New Customer Registration.',
                'from' => ['name' => env('MAIL_FROM_NAME'), 'address' => env('MAIL_FROM_ADDRESS')],
                'view' => 'email_template',
                'data' => $data
            ];

     Mail::to($data['email'])->send(new SendMail($param));
     return redirect()->route('admin.customer.show')->with('success', 'Customer Add Successfully.');

            
   }

     public function show($id) {
        $customer = Customer::where('id', '=', $id)->first(); 
        $states = HeaderHelper::states();       
        return view('admin/reports/customers/edit', compact('customer','states'));    
    }

     public function update(Request $request, $id) {
      $Customer = Customer::where('id', '=', $id)->first();
      $Customer->username = $request->username;
      $Customer->firstname = $request->firstname;
      $Customer->lastname = $request->lastname;
      $Customer->email = $request->email;
      $Customer->password = Hash::make($request->password);
      $Customer->phone_one = $request->phone_one;
      $Customer->phone_two = $request->phone_two;
      $Customer->phone_three = $request->phone_three;

      $Customer->address_one = $request->address_one;
      $Customer->address_two = $request->address_two;
      $Customer->address_three = $request->address_three;
      $Customer->address_four = $request->address_four;

      $Customer->area = $request->area;
      $Customer->state = $request->state;
      $Customer->postcode = $request->postcode;
      $Customer->models = $request->models;
      $Customer->serial_no = $request->serial_no;
      $Customer->remarks = $request->remarks;
      $Customer->purchase_date = $request->purchase_date;
      $Customer->status = $request->get('status',0);

      $Customer->save();
      if ($request->hasFile('image')) {
            $image = $request->file('image');
            $fileName = time() . "customer." . $image->getClientOriginalExtension();
            $image->move(public_path('uploads/site/customers/'), $fileName);

            if ($Customer->image != 'photo.jpg' && is_file(public_path('uploads/site/customers/' . $Customer->image))) {
                unlink(public_path('uploads/site/customers/' . $Customer->image));
            }
            $Customer->image = $fileName;
            $Customer->save();
        }            

      

    return redirect()->route('admin.customer.show')->with('success', 'Customer Update Successfully .');
    }



   

     public function destroy($id) {
        $c = Customer::find($id); 
        $c->delete(); //delete the User
        return redirect()->route('admin.customer.show')->with('success', 'Customer Delete Successfully.');
    }

    
    
    

}

