<?php



namespace App\Http\Controllers\Admin\Reports;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Helpers\HeaderHelper;
use App\Mail\SendMail;
use App\Models\Customer;
use App\Models\Lead;
use App\Models\User;
use App\Models\Policy;
use App\Models\Activity;
use App\Models\CustomerActivity;
use App\Models\ContactActivity;
use App\Models\Insurance;
use Validator;
use Image;
use Auth;



class ContactActivityController  extends Controller

{    

    public function index(Request $request){     
     $contacts = ContactActivity::get();     
       
    return view('admin/reports/contactactivity/index', compact('contacts'));
   }


    public function create(Request $request){                 
       $page_title = 'Add Call Notes';
       $customers  = Customer::get();
       $insurances  = Insurance::get();
       return view('admin/reports/contactactivity/add', compact('page_title','customers','insurances'));    
      }

     public function store(Request $request){ 

      $Activity = new ContactActivity;
      $Activity->customer_id = $request->customer_id;
      $Activity->name = $request->name;
      $Activity->email = $request->email;
      $Activity->contact_no = $request->contact_no;      
      $Activity->organisation = $request->organisation;      
      
      $Activity->save();
      return redirect()->route('admin.reports.contacts.activity.show')->with('success', 'Contact Call Activity Add Successfully.');

            
   }

     public function show($id) {
        $activity = ContactActivity::where('id', '=', $id)->first(); 
        $customers  = Customer::get();  
        return view('admin/reports/contactactivity/edit', compact('activity','customers'));    
    }

     public function update(Request $request, $id) {
      $Activity = ContactActivity::where('id', '=', $id)->first();
      $Activity->customer_id = $request->customer_id;
      $Activity->name = $request->name;
      $Activity->email = $request->email;
      $Activity->contact_no = $request->contact_no;      
      $Activity->organisation = $request->organisation; 
      $Activity->save();            

    return redirect()->route('admin.reports.contacts.activity.show')->with('success', 'Contact Call Activity Update Successfully .');
    }



   

     public function destroy($id) {
        $a = ContactActivity::find($id); 
        $a->delete(); //delete the User
        return redirect()->route('admin.reports.contacts.activity.show')->with('success', 'Contact Call Activity Delete Successfully.');
    }

    
    
    

}

