<?php



namespace App\Http\Controllers\Admin\Reports;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Helpers\HeaderHelper;
use App\Mail\SendMail;
use App\Models\Customer;
use App\Models\Lead;
use App\Models\User;
use App\Models\Policy;
use App\Models\CallActivity;
use App\Models\CustomerActivity;
use App\Models\ProspectsActivity;
use Validator;
use Image;
use Auth;



class ActivityController extends Controller

{    

    public function index(Request $request){     
    $page_title = 'Lead Activity Reports';   
    $follow_up= $request->follow_up;
    $start_date = $request->start_date;
    $stop_date = $request->stop_date;
    if($request->search == 'Search'){
        if(isset($request->follow_up)){
            $activities = CallActivity::join('users as u1', 'call_activities.user_id', '=', 'u1.id')
                        ->whereBetween('call_activities.created_at',[$request->start_date, $request->stop_date])
                        ->where('call_activities.follow_up_date',$request->follow_up)
                        ->join('leads as l1', 'call_activities.lead_id', '=', 'l1.id')
                        ->select('call_activities.*','u1.name as staffname','l1.firstname as leadname')
                        ->get(); 
        }
        else{
            $activities = CallActivity::join('users as u1', 'call_activities.user_id', '=', 'u1.id')
                        ->whereBetween('call_activities.created_at',[$request->start_date, $request->stop_date])
                        ->join('leads as l1', 'call_activities.lead_id', '=', 'l1.id')
                        ->select('call_activities.*','u1.name as staffname','l1.firstname as leadname')
                        ->get(); 
        }

    } 
    else{
        $activities = CallActivity::join('users as u1', 'call_activities.user_id', '=', 'u1.id')
                        ->join('leads as l1', 'call_activities.lead_id', '=', 'l1.id')
                        ->select('call_activities.*','u1.name as staffname','l1.firstname as leadname')
                        ->get(); 
    }
      
    
    return view('admin/reports/activity/index', compact('page_title', 'activities','start_date','stop_date','follow_up'));    
   }


    public function create(Request $request){                 
       $page_title = 'Add Call Notes';
       $customers  = Customer::get();
       $leads  = Lead::get();
       //dd([$leads,$customers]);
       return view('admin/reports/activity/add', compact('page_title','customers','leads'));    
      }

     public function store(Request $request){ 

      $Activity = new Activity;
      $Activity->lead_id = $request->lead_id;
      $Activity->lead_name = $request->lead_name;
      $Activity->lead_email = $request->lead_email;
      $Activity->lead_contact_no = $request->lead_contact_no;      
      $Activity->staff_id = Auth::user()->id;
      $Activity->staff_name = Auth::user()->firstname.' '.Auth::user()->lastname;
      $Activity->follow_up = $request->follow_up;
      $Activity->notes = $request->notes;      
      $Activity->appointment_time = date("h:i:s");
     // dd($Lead);
      $Activity->save();
      return redirect()->route('admin.reports.activity.show')->with('success', 'Call Notes Add Successfully.');

            
   }

     public function show($id) {
        $activity = Activity::where('id', '=', $id)->first(); 
        $leads  = Lead::get();      
        return view('admin/reports/activity/edit', compact('activity','leads'));    
    }

     public function update(Request $request, $id) {
      $Activity = Activity::where('id', '=', $id)->first();
      $Activity->lead_id = $request->lead_id;
      $Activity->lead_name = $request->lead_name;
      $Activity->lead_email = $request->lead_email;
      $Activity->lead_contact_no = $request->lead_contact_no;      
      $Activity->staff_id = Auth::user()->id;
      $Activity->staff_name = Auth::user()->firstname.' '.Auth::user()->lastname;
      $Activity->follow_up = $request->follow_up;
      $Activity->notes = $request->notes;      
      $Activity->appointment_time = date("h:i:s");
     
      $Activity->save();            

    return redirect()->route('admin.reports.activity.show')->with('success', 'Call Note Update Successfully .');
    }



     public function destroy($id) {
        $a = Activity::find($id); 
        $a->delete(); //delete the User
        return redirect()->route('admin.reports.activity.show')->with('success', 'Lead Call Note Delete Successfully.');
    }


    public function export(Request $request){
        $fileName="";
        $activities=[];
        if($request->input('start_date')!==null && $request->input('stop_date')!==null){
            $fileName = 'LeadCallActivitybtw-'.$request->input('start_date').'-'.$request->input('stop_date').'.csv'; 
          
            $activities = CallActivity::join('users as u1', 'call_activities.user_id', '=', 'u1.id')
                ->join('leads as l1', 'call_activities.lead_id', '=', 'l1.id')
                ->whereBetween('call_activities.created_at',[$request->input('start_date'), $request->input('stop_date')])
                ->select('call_activities.*','u1.name as staffname','l1.firstname as leadname')
                ->get();
            }
            else{
                $fileName = 'LeadCallActivity.csv'; 

                $activities = CallActivity::join('users as u1', 'call_activities.user_id', '=', 'u1.id')
                    ->join('leads as l1', 'call_activities.lead_id', '=', 'l1.id')
                    ->select('call_activities.*','u1.name as staffname','l1.firstname as leadname')
                    ->get();
     
            }


            $headers = array(
                "Content-type"        => "text/csv",
                "Content-Disposition" => "attachment; filename=$fileName",
                "Pragma"              => "no-cache",
                "Cache-Control"       => "must-revalidate, post-check=0, pre-check=0",
                "Expires"             => "0"
            );
            $columns = array('Call By', 'Lead Name', 'Subject','Call Date','Follow Up','Status');

            $callback = function() use($activities, $columns) {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columns);

            foreach ($activities as $activity) {
                
                $row['Call By']        = $activity->staffname;
                $row['Lead Name']      = $activity->leadname;
                $row['Subject']        = $activity->subject;
                $row['Call Date']      = date('d-M-Y', strtotime($activity->start_date));
                $row['Follow Up']      = date('d-M-Y', strtotime($activity->follow_up));
                $row['Status']         = $activity->status;
            
            fputcsv($file, array( $row['Call By'], $row['Lead Name'], $row['Subject'], $row['Call Date'], $row['Follow Up'], $row['Status']));
            }

            fclose($file);
        };
    
        return response()->stream($callback, 200, $headers);
    }

    
    
    

}

