<?php



namespace App\Http\Controllers\Admin\Management;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Exports\BulkExport;
use App\Imports\BulkImport;
use Maatwebsite\Excel\Facades\Excel;

use App\Helpers\HeaderHelper;
use App\Helpers\UserHelper;
use App\Mail\SendMail;
use App\Models\Customer;
use App\Models\Insurance;
use App\Models\User;
use App\Models\Lead;
use Validator;
use Image;
use Auth;


class LeadController extends Controller

{    

    public function index(Request $request){     
    $page_title = 'Leads'; 
      $start_date = $request->start_date;
      $stop_date = $request->stop_date;    
    $supervisorLists =  UserHelper::getAssignedSuperVisorUsersList(Auth::user()->id);   
    $assigned_by = $request->assigned_by;
    if($request->search == 'Search'){
     
      
      if(isset($request->assigned_by)){
        // $ids = [0];
        //   foreach ($supervisorLists as $key => $value) { 
        //     $ids[] = $value['assign_user_id'];
        //   }
          $leads = Lead::join('users', 'leads.user_id', '=', 'users.id')
                  ->whereBetween('leads.created_at',[$start_date, $stop_date])
                  ->where('leads.assigned_by_user_name','like',"%{$assigned_by}%")
                  ->select('leads.*','users.name as staffname')
                  ->get();
        }
        else{
          // $ids = [0];
          // foreach ($supervisorLists as $key => $value) { 
          //   $ids[] = $value['assign_user_id'];
          // }
          $leads = Lead::join('users', 'leads.user_id', '=', 'users.id')
                  ->whereBetween('leads.created_at',[$start_date, $stop_date])
                  ->select('leads.*','users.name as staffname')
                  ->get();
        }
      }
      else{
        // $ids = [0];
        // foreach ($supervisorLists as $key => $value) { 
        //   $ids[] = $value['assign_user_id'];
        // }
          $leads = Lead::join('users', 'leads.user_id', '=', 'users.id')
        ->select('leads.*','users.name as staffname')
        ->get();
      }
     
    return view('admin/managements/index', compact('page_title', 'leads','start_date','stop_date'));    
   }


    public function create(Request $request){ 
                
       $page_title = 'Add Leads';
       $sources = HeaderHelper::leadSource();
       $states = HeaderHelper::states();
       $staffs = User::where('user_role', '=', 3)->get()->toArray();

       $teamleads = User::where('user_role', '=', 4)->get()->toArray();
       $insurances = Insurance::get();
       //dd($teamleads);
       return view('admin/managements/add', compact('page_title','states','staffs','teamleads','sources','insurances'));    
      }

     public function store(Request $request){ 
      //dd($request);
      $this->validate($request,[
            'contact_no' => 'required|digits:11|numeric',
            
      ]);
      $Lead = new Lead;
      $Lead->type = $request->type;
      if($request->type == 'staff'){
        $Lead->user_id = $request->staff_user_role;
      }else{
        $Lead->user_id = $request->teamlead_user_role;

      }
      
      $Lead->assigned_by_user_id = Auth::user()->id;

      if($request->type == 'staff'){
        $Lead->user_role = User::where('id','=',$request->staff_user_role)->pluck('user_role')->first();
      }else{
       $Lead->user_role = User::where('id','=',$request->teamlead_user_role)->pluck('user_role')->first();

      }
     
      $Lead->assigned_by_user_name = Auth::user()->name.' '.Auth::user()->lastname;
      $Lead->firstname = $request->firstname;
      $Lead->lastname = $request->lastname;
      $Lead->email = $request->email;

      $Lead->contact_no = $request->contact_no;
     
      $Lead->address = $request->address;
      $Lead->city = $request->city;
      $Lead->state = $request->state;
      /*$Lead->post_code = $request->postcode;*/

      $Lead->lead_source = $request->lead_source;
      $Lead->lead_description = $request->lead_description;
      $Lead->lead_type = $request->lead_type;
      $Lead->orgnisation_type = $request->orgnisation_type;
      if($request->orgnisation_type  ==  'Company'){
        $Lead->nature_of_organisation = $request->nature_of_org_company;
      }else{
         $Lead->nature_of_organisation = $request->nature_of_org_individual;
      }
     
      $Lead->referred_by = $request->referred_by;
      $Lead->save();


       
      return redirect()->route('management.leads.show')->with('success', 'Lead Create Successfully.');

            
   }

     public function show($id) {
        $lead = Lead::where('id', '=', $id)->first(); 
        $sources = HeaderHelper::leadSource();
        $states = HeaderHelper::states();    
        $staffs = User::where('user_role', '=', 3)->get()->toArray();
        $teamleads = User::where('user_role', '=', 4)->get()->toArray();  
        $insurances = Insurance::get();
        return view('admin/managements/edit', compact('lead','states','staffs','teamleads','sources','insurances'));    
    }

     public function update(Request $request, $id) {
      //dd($request);
      $this->validate($request,[
           'contact_no' => 'required|digits:11|numeric',
            
      ]);  
      $Lead = Lead::where('id', '=', $id)->first();    
      $Lead->type = $request->type;
      if($request->type == 'staff'){
        $Lead->user_id = $request->staff_user_role;
      }else{
        $Lead->user_id = $request->teamlead_user_role;

      }
      
      $Lead->assigned_by_user_id = Auth::user()->id;
      if($request->type == 'staff'){
        $Lead->user_role = User::where('id','=',$request->staff_user_role)->pluck('user_role')->first();
      }else{
       $Lead->user_role = User::where('id','=',$request->teamlead_user_role)->pluck('user_role')->first();

      }
      $Lead->assigned_by_user_name = Auth::user()->name.' '.Auth::user()->lastname;

      $Lead->firstname = $request->firstname;
      $Lead->lastname = $request->lastname;
      $Lead->email = $request->email;
     
      
      $Lead->contact_no = $request->contact_no;
      $Lead->address = $request->address;

      $Lead->city = $request->city;
      $Lead->state = $request->state;
      /*$Lead->post_code = $request->postcode;*/

      $Lead->lead_source = $request->lead_source;
      $Lead->lead_description = $request->lead_description;
      $Lead->lead_type = $request->lead_type;
      
      $Lead->orgnisation_type = $request->orgnisation_type;
      if($request->orgnisation_type  ==  'Company'){
        $Lead->nature_of_organisation = $request->nature_of_org_company;
      }else{
         $Lead->nature_of_organisation = $request->nature_of_org_individual;
      }
      $Lead->referred_by = $request->referred_by;

      $Lead->save();
               

      

    return redirect()->route('management.leads.show')->with('success', 'Lead Update Successfully.');
    }

  

     public function destroy($id) {
        $c = Lead::find($id); 
        $c->delete();
        return redirect()->route('management.leads.show')->with('success', 'Lead Delete Successfully.');
    }

     public function details($id) {
        $lead = Lead::where('id', '=', $id)->first(); 
        $insurances = Insurance::get();
        //dd($insurances);          
        return view('admin/managements/detail', compact('lead','insurances'));  
    }

   public function importExportView(Request $request){                 
       $page_title = 'Add Import';
       return view('admin/managements/import', compact('page_title'));    
      }
    
    public function import(Request $request)   {
      $this->validate($request, [
         'file'=> 'required|mimes:xls,xlsx'
     ]);

      $path = $request->file('file')->getRealPath();
      Excel::import(new BulkImport,request()->file('file'));
      return redirect()->route('management.leads.show')->with('success', 'Excel Data Imported successfully.');

    }

     public function exportCsv(Request $request){
       $fileName="";
       $leads =[];
      if($request->input('start_date')!==null && $request->input('stop_date')!==null){
          $fileName = 'leadsbtw-'.$request->input('start_date').'and'.$request->input('stop_date').'.csv';

          $leads =  Lead::
          join('users', 'leads.user_id', '=', 'users.id')
          ->select('leads.*','users.name as staffname')
          ->whereBetween('leads.created_at',[$request->input('start_date'), $request->input('stop_date')])
          ->get(); 
      }
      else{
          $fileName = 'leads.csv';

          $leads =  Lead::
          join('users', 'leads.user_id', '=', 'users.id')
          ->select('leads.*','users.name as staffname')
          ->get(); 
      }


   
        $headers = array(
            "Content-type"        => "text/csv",
            "Content-Disposition" => "attachment; filename=$fileName",
            "Pragma"              => "no-cache",
            "Cache-Control"       => "must-revalidate, post-check=0, pre-check=0",
            "Expires"             => "0"
        );

        $columns = array('Assigned By', 'Name', 'Email', 'Contact','Addess','City','Lead Type','Organisation Type','Referred by');

            $callback = function() use($leads, $columns) {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columns);

            foreach ($leads as $account) {
                $row['Assigned By']   = $account->assigned_by_user_name;
                $row['Name']     = $account->firstname.' '.$account->lastname;
                $row['Email']     = $account->email;
                $row['Contact']   = $account->contact_no;
                $row['Addess']       = $account->address;
                $row['City'] = $account->city;
                $row['Lead Type']   = $account->lead_type;
                $row['Organisation Type']  = $account->orgnisation_type;
                $row['Referred by']  = $account->referred_by;

                fputcsv($file, array($row['Assigned By'], $row['Name'], $row['Email'], $row['Contact'], $row['Addess'], $row['City'], $row['Lead Type'], $row['Organisation Type'],$row['Referred by']));
            }

            fclose($file);
        };

        
        
        return response()->stream($callback, 200, $headers);
    }

    

}

