<?php



namespace App\Http\Controllers\Admin\Audit;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Exports\BulkExport;
use App\Imports\BulkImport;
use Maatwebsite\Excel\Facades\Excel;

use App\Helpers\HeaderHelper;
use App\Mail\SendMail;
use App\Models\Customer;
use App\Models\Insurance;
use App\Models\User;
use App\Models\Lead;
use Validator;
use Image;
use Auth;


class LeadController extends Controller

{    

    public function index(Request $request){     
    $page_title = 'Leads'; 
      $start_date = $request->start_date;
      $stop_date = $request->stop_date;   
      $assigned_by = $request->assigned_by;
    if($request->search == 'Search'){
      if(isset($request->assigned_by)){
        $leads = Lead::where('leads.user_role','=',3)
              ->whereBetween('leads.created_at',[$request->start_date, $request->stop_date])
              ->where('leads.assigned_by_user_name','like',"%{$assigned_by}%")
              ->join('users', 'leads.user_id', '=', 'users.id')
              ->select('leads.*','users.name as staffname')
              ->get();
      }
      else{
        $leads = Lead::where('leads.user_role','=',3)
          ->whereBetween('leads.created_at',[$request->start_date, $request->stop_date])
          ->join('users', 'leads.user_id', '=', 'users.id')
          ->select('leads.*','users.name as staffname')
          ->get();
      }
      
    }else{


      $leads = Lead::where('leads.user_role','=',3)
      ->join('users', 'leads.user_id', '=', 'users.id')
      ->select('leads.*','users.name as staffname')
      ->get(); 
    

    } 
          
     //dd($leads);
    return view('admin/audit/index', compact('page_title', 'leads','start_date','stop_date','assigned_by'));    
   }


    public function create(Request $request){ 
                
       $page_title = 'Add Leads';
       $sources = HeaderHelper::leadSource();
       $states = HeaderHelper::states();
       $staffs = User::where('user_role', '=', 3)->get()->toArray();

       $teamleads = User::where('user_role', '=', 4)->get()->toArray();
       $insurances = Insurance::get();
       //dd($teamleads);
       return view('admin/audit/add', compact('page_title','states','staffs','teamleads','sources','insurances'));    
      }

     public function store(Request $request){ 
      //dd($request);
      $this->validate($request,[
            'contact_no' => 'required|digits:11|numeric',
            
      ]);
      $Lead = new Lead;
      $Lead->type = $request->type;
      if($request->type == 'staff'){
        $Lead->user_id = $request->staff_user_role;
      }else{
        $Lead->user_id = $request->teamlead_user_role;

      }
      
      $Lead->assigned_by_user_id = Auth::user()->id;

      if($request->type == 'staff'){
        $Lead->user_role = User::where('id','=',$request->staff_user_role)->pluck('user_role')->first();
      }else{
       $Lead->user_role = User::where('id','=',$request->teamlead_user_role)->pluck('user_role')->first();

      }
     
      $Lead->assigned_by_user_name = Auth::user()->name.' '.Auth::user()->lastname;
      $Lead->firstname = $request->firstname;
      $Lead->lastname = $request->lastname;
      $Lead->email = $request->email;

      $Lead->contact_no = $request->contact_no;
     
      $Lead->address = $request->address;
      $Lead->city = $request->city;
      $Lead->state = $request->state;
      /*$Lead->post_code = $request->postcode;*/

      $Lead->lead_source = $request->lead_source;
      $Lead->lead_description = $request->lead_description;
      $Lead->lead_type = $request->lead_type;
      $Lead->orgnisation_type = $request->orgnisation_type;
      if($request->orgnisation_type  ==  'Company'){
        $Lead->nature_of_organisation = $request->nature_of_org_company;
      }else{
         $Lead->nature_of_organisation = $request->nature_of_org_individual;
      }
     
      $Lead->referred_by = $request->referred_by;
      $Lead->save();


       
      return redirect()->route('audit.leads.show')->with('success', 'Lead Create Successfully.');

            
   }

     public function show($id) {
        $lead = Lead::where('id', '=', $id)->first(); 
        $sources = HeaderHelper::leadSource();
        $states = HeaderHelper::states();    
        $staffs = User::where('user_role', '=', 3)->get()->toArray();
        $teamleads = User::where('user_role', '=', 4)->get()->toArray();  
        $insurances = Insurance::get();
        return view('admin/audit/edit', compact('lead','states','staffs','teamleads','sources','insurances'));    
    }

     public function update(Request $request, $id) {
      //dd($request);
      $this->validate($request,[
           'contact_no' => 'required|digits:11|numeric',
            
      ]);  
      $Lead = Lead::where('id', '=', $id)->first();    
      $Lead->type = $request->type;
      if($request->type == 'staff'){
        $Lead->user_id = $request->staff_user_role;
      }else{
        $Lead->user_id = $request->teamlead_user_role;

      }
      
      $Lead->assigned_by_user_id = Auth::user()->id;
      if($request->type == 'staff'){
        $Lead->user_role = User::where('id','=',$request->staff_user_role)->pluck('user_role')->first();
      }else{
       $Lead->user_role = User::where('id','=',$request->teamlead_user_role)->pluck('user_role')->first();

      }
      $Lead->assigned_by_user_name = Auth::user()->name.' '.Auth::user()->lastname;

      $Lead->firstname = $request->firstname;
      $Lead->lastname = $request->lastname;
      $Lead->email = $request->email;
     
      
      $Lead->contact_no = $request->contact_no;
      $Lead->address = $request->address;

      $Lead->city = $request->city;
      $Lead->state = $request->state;
      /*$Lead->post_code = $request->postcode;*/

      $Lead->lead_source = $request->lead_source;
      $Lead->lead_description = $request->lead_description;
      $Lead->lead_type = $request->lead_type;
      
      $Lead->orgnisation_type = $request->orgnisation_type;
      if($request->orgnisation_type  ==  'Company'){
        $Lead->nature_of_organisation = $request->nature_of_org_company;
      }else{
         $Lead->nature_of_organisation = $request->nature_of_org_individual;
      }
      $Lead->referred_by = $request->referred_by;

      $Lead->save();
               

      

    return redirect()->route('audit.leads.show')->with('success', 'Lead Update Successfully.');
    }

  

     public function destroy($id) {
        $c = Lead::find($id); 
        $c->delete();
        return redirect()->route('audit.leads.show')->with('success', 'Lead Delete Successfully.');
    }

     public function details($id) {
        $lead = Lead::where('id', '=', $id)->first(); 
        $insurances = Insurance::get();
        //dd($insurances);          
        return view('admin/audit/detail', compact('lead','insurances'));  
    }

   public function importExportView(Request $request){                 
       $page_title = 'Add Import';
       return view('admin/audit/import', compact('page_title'));    
      }
    
    public function import(Request $request)   {
      $this->validate($request, [
         'file'=> 'required|mimes:xls,xlsx'
     ]);

      $path = $request->file('file')->getRealPath();
      Excel::import(new BulkImport,request()->file('file'));
      return redirect()->route('audit.leads.show')->with('success', 'Excel Data Imported successfully.');

    }

    

}

