<?php



namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Mail\SendMail;
use App\Models\Agency;
use Validator;
use Image;



class AgencyController extends Controller

{    

    public function index(Request $request){     
    $page_title = 'Agencies';
    $agencies      = Agency::get();       
    return view('admin/agencies/index', compact('page_title', 'agencies'));    
   }


    public function create(Request $request){                 
       $page_title = 'Add Agency';
       return view('admin/agencies/add', compact('page_title'));    
      }

     public function store(Request $request){ 
      $Agency             = new Agency;
      $Agency->agency_category_id       = $request->agency_category_id;  
      $Agency->agency_category_name       = $request->agency_category_name;    
      $Agency->name       = $request->name; 
      $Agency->save();
     return redirect()->route('admin.agencies.show')->with('success', 'Agency Add Successfully.');

            
   }

     public function show($id) {
        $agency = Agency::where('id', '=', $id)->first();              
        return view('admin/agencies/edit', compact('agency'));    
    }

     public function update(Request $request, $id) {
      $Agency             = Agency::where('id', '=', $id)->first();
      $Agency->agency_category_id       = $request->agency_category_id;
      $Agency->agency_category_name       = $request->agency_category_name;
      $Agency->name       = $request->name; 
      $Agency->save();       
      return redirect()->route('admin.agencies.show')->with('success', 'Agency Update Successfully .');
    }
   

     public function destroy($id) {
        $i = Agency::find($id); 
        $i->delete(); 
        return redirect()->route('admin.agencies.show')->with('success', 'Agency Delete Successfully.');
    }

    
    
    

}

