<?php

namespace App\Helpers;

use GuzzleHttp\Client;
use App\Models\Service;
use App\Models\Admin;
use App\Models\AssignUser;
use DB;
use Cookie;

class UserHelper
{
    
    public static function usersGroup (){

      return $users = [
            '1'=>'North',                      
            '2'=>'South',
            
        ];
     }

      public static function northBranches (){

      return $northBranches = [
            'KADUNA'=>'KADUNA',                      
            'BAUCHI'=>'BAUCHI',
            'KANO'=>'KANO',
            'ABUJA'=>'ABUJA'
        ];
     }

      public static function southBranches (){

      return $southBranches = [
            'LAGOS'=>'LAGOS',                      
            'ONITSHA'=>'ONITSHA',
            'PORTHARCOURT'=>'PORTHARCOURT',
            'IBADAN'=>'IBADAN',
            
        ];
     }

     public static function users (){

     	return $users = [
            '2'=>'Admin',                      
            '3'=>'BD Staff',
            '4'=>'Team Leads',
            '5'=>'Supervisors',
            '6'=>'Management',
            '7'=>'Audit',
            '8'=>'Customer-Service'

        ];
     }

      public static function daysInyearsBKP (){

        return $terms = [
            '30 days'=>'30 Days',                      
            '90 days'=>'90 Days',
            '180 days'=>'180 Days',
            '1 Year'=>'365 Days',
            '2 Year'=>'730 Days',
            '3 Year'=>'1095 Days',
            '4 Year'=>'1460 Days',
            '5 Year'=>'1825 Days',

        ];
     }

     public static function daysInyears (){

        return $terms = [
            '30'=>'30 Days',                      
            '90'=>'90 Days',
            '180'=>'180 Days',
            '365'=>'365 Days',
            '730'=>'730 Days',
            '1095'=>'1095 Days',
            '1460'=>'1460 Days',
            '1825'=>'1825 Days',

        ];
     }

     public static function departments_old (){

        return $departments = [
            'CORPORATE SERVICES'=>'CORPORATE SERVICES',  
            'ED OFFICE'=>'ED OFFICE',
            'FINANCE & INVESTMENT'=>'FINANCE & INVESTMENT',
            'INFORMATION TECHNOLOGY'=>'INFORMATION TECHNOLOGY',
            'INTERNAL AUDIT & CONTROL'=>'INTERNAL AUDIT & CONTROL',
            'LEGAL'=>'LEGAL',
            'MD OFFICE'=>'MD OFFICE',
            'STRATEGY & RESEARCH'=>'STRATEGY & RESEARCH',
            'TECHNICAL'=>'TECHNICAL',
            'BUSINESS DEVELOPMENT'=>'BUSINESS DEVELOPMENT'

        ];
     }
     
     public static function departments (){

        return $departments = [
            'MARKETING & CORPORATE COMMUNICATIONS (MCC)'=>'MARKETING & CORPORATE COMMUNICATIONS (MCC)',
            'CORPORATE SERVICES (PROCUREMENT)'=>'CORPORATE SERVICES (PROCUREMENT)',
            'CORPORATE SERVICES (CIC)'=>'CORPORATE SERVICES (CIC)',
            'CORPORATE SERVICES (HCM)'=>'CORPORATE SERVICES (HCM)',
            'ED OFFICE'=>'ED OFFICE',
            'FINANCE & INVESTMENT'=>'FINANCE & INVESTMENT',
            'INFORMATION TECHNOLOGY'=>'INFORMATION TECHNOLOGY',
            'INTERNAL AUDIT & CONTROL'=>'INTERNAL AUDIT & CONTROL',
            'LEGAL'=>'LEGAL',
            'MD OFFICE'=>'MD OFFICE',
            'STRATEGY & RESEARCH'=>'STRATEGY & RESEARCH',
            'TECHNICAL (CLAIMS)'=>'TECHNICAL (CLAIMS)',
            'TECHNICAL (UNDERWRITING)'=>'TECHNICAL (UNDERWRITING)',
            'TECHNICAL (REINSURANCE)'=>'TECHNICAL (REINSURANCE)',
            'ENTERPRISE RISK MANAGEMENT'=>'ENTERPRISE RISK MANAGEMENT',
            'BUSINESS DEVELOPMENT'=> 'BUSINESS DEVELOPMENT',
            'BUSINESS DEVELOPMENT (AGRIC)'=>'BUSINESS DEVELOPMENT (AGRIC)',
            'BUSINESS DEVELOPMENT (OIL & GAS)'=>'BUSINESS DEVELOPMENT (OIL & GAS)',
            'BUSINESS DEVELOPMENT (LAGOS BRANCH)'=> 'BUSINESS DEVELOPMENT (LAGOS BRANCH)',
            'BUSINESS DEVELOPMENT (ABUJA BRANCH)'=> 'BUSINESS DEVELOPMENT (ABUJA BRANCH)',
            'BUSINESS DEVELOPMENT (KADUNA BRANCH)'=> 'BUSINESS DEVELOPMENT (KADUNA BRANCH)',
            'BUSINESS DEVELOPMENT KANO BRANCH)'=>'BUSINESS DEVELOPMENT KANO BRANCH)',
            'BUSINESS DEVELOPMENT (BAUCHI BRANCH)'=>'BUSINESS DEVELOPMENT (BAUCHI BRANCH)',
            'BUSINESS DEVELOPMENT (IBADAN BRANCH)'=> 'BUSINESS DEVELOPMENT (IBADAN BRANCH)',
            'BUSINESS DEVELOPMENT (ONITSHA BRANCH)'=>'BUSINESS DEVELOPMENT (ONITSHA BRANCH)',
            'BUSINESS DEVELOPMENT (PORT HACOURT BRANCH)'=>'BUSINESS DEVELOPMENT (PORT HACOURT BRANCH)',

        ];
     }

     public static function currency (){

        return $currency = [
            'US DOLLAR'=>'$ US DOLLAR',                      
            'INR'=>'₹ INR',
            'NGN'=>'₦ NGN',           

        ];
     }

      public static function agency (){

        return $agency = [
            'Agriculture'=>'Agriculture',                      
            'Aviation'=>'Aviation',
            'Bold'=>'Bold',           
            'Engineering'=>'Engineering',   
            'Fire'=>'Fire',   
            'General Accident'=>'General Accident', 

        ];
     }

      public static function policyClasses (){

        return $policyClasses = [
            'Agriculture'=>'Agriculture',                      
            'Aviation'=>'Aviation',
            'Bold'=>'Bold',           
            'Engineering'=>'Engineering',   
            'Fire'=>'Fire',   
            'General Accident'=>'General Accident', 
            'Health Insurance'=>'Health Insurance',                      
            'Liability/WCA'=>'Liability/WCA',
            'Liability/WCA-EL'=>'Liability/WCA-EL',           
            'Marine'=>'Marine',   
            'Motor'=>'Motor',   
            'Oil/Gas'=>'Oil/Gas', 
            'Others'=>'Others', 

        ];
     }

     public static function policyBranches (){

        return $policyBranches = [
            'Annex Office Lagos'=>'Annex Office Lagos',                      
            'Bauchi'=>'Bauchi',
            'Benin'=>'Benin',           
            'Head Office'=>'Head Office',   
            'Ibadan'=>'Ibadan',   
            'Kuduna'=>'Kuduna', 
            'Kano'=>'Kano', 
            'Minna'=>'Minna', 
            'Onitsha'=>'Onitsha', 
            'Port-Harcourt'=>'Port-Harcourt', 
            'Sokoto'=>'Sokoto', 
            'Warri'=>'Warri', 

        ];
     }

      public static function occupationalExposure (){

        return $occupationalExposure = [
            'All-Peps'=>'All-Peps',                      
            'High'=>'High',
            'Low'=>'Low',           
            'Medium'=>'Medium',   
            'Politician'=>'Politician'

        ];
     }

  public static function businessLocations (){

        return $occupationalExposure = array (
  'Abia' => 'Abia',
  'Adamawa' => 'Adamawa',
  'Akwa Ibom' => 'Akwa Ibom',
  'Anambra' => 'Anambra',
  'Bauchi' => 'Bauchi',
  'Bayelsa' => 'Bayelsa',
  'Benue' => 'Benue',
  'Borno' => 'Borno',
  'Cross River' => 'Cross River',
  'Delta' => 'Delta',
  'Ebonyi' => 'Ebonyi',
  'Edo' => 'Edo',
  'Ekiti' => 'Ekiti',
  'Enugu' => 'Enugu',
  'FCT - Abuja' => 'FCT - Abuja',
  'Gombe' => 'Gombe',
  'Imo' => 'Imo',
  'Jigawa' => 'Jigawa',
  'Kaduna' => 'Kaduna',
  'Kano' => 'Kano',
  'Katsina' => 'Katsina',
  'Kebbi' => 'Kebbi',
  'Kogi' => 'Kogi',
  'Kwara' => 'Kwara',
  'Lagos' => 'Lagos',
  'Nasarawa' => 'Nasarawa',
  'Niger' => 'Niger',
  'Ogun' => 'Ogun',
  'Ondo' => 'Ondo',
  'Osun' => 'Osun',
  'Oyo' => 'Oyo',
  'Plateau' => 'Plateau',
  'Rivers' => 'Rivers',
  'Sokoto' => 'Sokoto',
  'Taraba' => 'Taraba',
  'Yobe' => 'Yobe',
  'Zamfara' => 'Zamfara',
);
     }
        

public static function uniqueUserVerification ($username, $email){

  return Admin::where('username','=',$username)->orWhere('email','=',$email)->exists();

}

public static function getTargetsBasedOnUser($cloID){

    $client = new Client();
    $response = $client->request('GET', 'https://enterprise.veritaskapital.com/api/target/'.$cloID);
    $statusCode = $response->getStatusCode();
    $targets = $response->getBody()->getContents();
    $targets = json_decode($targets); 
    
    if(!empty($targets->data)){
      return $targets->data[0]->target;
    }else{
      0;
    }
    

}


public static function getAssignStaffsUserList ($authID){

  return AssignUser::where('user_id','=',$authID)->select('assign_user_id')->get()->toArray();  

}


public static function getAssignedTeamLeadUsersList ($authID){
  $teamleads=[];
  $staffs=[];
  $teamleads =  AssignUser::where('user_id','=',$authID)->select('assign_user_id')->get()->toArray();  
 
  foreach ($teamleads as $key => $value) {
    //  var_dump($value);
    $staffs = self::getAssignStaffsUserList($value['assign_user_id']); 
 
  }
  // dd($teamleads,$staffs);
  return array_merge($teamleads,$staffs);

}

public static function getAssignedSuperVisorUsersList ($authID){

   $supervisors =  AssignUser::where('user_id','=',$authID)->select('assign_user_id')->get();     
  $teamleads=[];
   foreach ($supervisors as $key => $value) {
     
    $teamleads = self::getAssignedTeamLeadUsersList($value->assign_user_id); 
 
  }
  // dd($authID,$supervisors,$teamleads);
  return array_merge($supervisors->toArray(),$teamleads);

}

        
}