<?php

namespace App\Helpers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use App\Mail\SendMail;
use App\Models\Sale;
use App\Models\Lead;
use App\Models\Account;
use App\Models\Task;
use App\Models\User;
use DB;
use Cookie;
use Auth;

class EmailHelper
{
    
     public static function sendEmailToUser($request){     
     //dd($request);
         $data = array(
          'insurance_no' => $request->insurance_no,
          'client_code' => $request->client_code,
          'agency' => $request->agency,
          'insurance_class' => $request->insurance_class,
          'insurance_type' => $request->insurance_type,
          'business_type' => $request->business_type,
          'insurance_group' => $request->insurance_group,
          'reference' => $request->reference,
          'currency' => $request->currency,
          'rate' => $request->rate,
          'issuance_date' => $request->issuance_date,
          'term' => $request->term,
          'cover_period_from' => $request->cover_period_from,
          'cover_period_to' => $request->cover_period_to,
          'limit_of_exposure' => $request->limit_of_exposure,
          'insurance_branch' => $request->insurance_branch,
          'business_location' => $request->business_location,
          'geographical_cover' => $request->geographical_cover,
          'occupational_exposure' => $request->occupational_exposure,
          'clo_name' => $request->clo_name,
          'user_id'=>$request->user_id,
          'insurance_status' => $request->insurance_status
          
        );

      
 
       foreach ($request->email as $key => $e) {
         
            $fromTitle = 'VKA CRM Team';
            $from =  'no_reply@veritaskapital.com';

            $subject = 'Lead Converted To Sales';
            $email = $e;
            $to = $email;
            $toTitle = 'Lead Converted To Sales';
            $data['to'] = $to;
            $param = [
                'subject' => $subject,
                'from' => ['name' => $fromTitle, 'address' => $from],
                'view' => 'emails.promotion.approvel_and_rejection_notification_to_partner',
                'data' => $data
            ];
            $to = ['name' => $toTitle, 'email' => $to];
            $to = (Object)$to;

            //dd($param);
             
              Mail::to($e)->send(new SendMail($param));
          
       }
        return true;
        
    
    }

    


     public static function leadConvertToSale($leadID){
        $Lead = Lead::where('id', '=', $leadID)->first();
        $Lead->status = 'Sale';
        $Lead->save();
        return true;
     }

     public static function createAccount($request){
     //dd($request);
      $checkExistingLead = Account::where('lead_id','=',$request->lead_id)->exists();
      
      if($checkExistingLead != true){
      $Account = new Account;
      $Account->user_id = $request->user_id;
      $Account->clo_id = $request->client_code;
      $Account->account_name = Lead::where('id','=',$request->lead_id)->pluck('firstname','lastname')->first();
      $Account->assigned_by_user_id = Sale::where('user_id','=',$request->user_id)->pluck('assigned_by_user_id')->first();
      
      $Account->lead_id = $request->lead_id;
      $Account->insurance_id = $request->insurance_id;
      $Account->insurance_name = $request->insurance_name;
      $Account->expire = $request->expire;
      $Account->price = $request->price;
      $Account->insurance_no = $request->insurance_no;
      $Account->client_code = $request->client_code;
      $Account->agency = $request->agency;      
      $Account->insurance_class = $request->insurance_class;
      $Account->insurance_type = $request->insurance_type;
      $Account->business_type = $request->business_type;
      $Account->insurance_group = $request->insurance_group;
      $Account->reference = $request->reference;
      $Account->currency = $request->currency;
      $Account->rate = $request->rate;
      $Account->issuance_date = $request->issuance_date;
      $Account->term = $request->term;
      $Account->cover_period_from = $request->cover_period_from;
      $Account->cover_period_to = $request->cover_period_to;
      $Account->limit_of_exposure = $request->limit_of_exposure;
      $Account->insurance_branch = $request->insurance_branch;
      $Account->business_location = $request->business_location;
      $Account->geographical_cover = $request->geographical_cover;
      $Account->occupational_exposure = $request->occupational_exposure;
      $Account->insurance_status = $request->insurance_status;    
      $Account->save();
      return true;
    }

     }
        

public static function sendEmailToTaskUser($id){  
  
  $user_id = Task::where('id','=',$id)->pluck('user_id')->first();
  $user = User::where('id','=',$user_id)->first();

  $data = array(
          'firstname' => $user->name,
          'lastname' => $user->lastname,
          'username' => $user->username,
          'email' => $user->email
          
        );


            $fromTitle = 'VKA CRM Team';
            $from =  'no_reply@veritaskapital.com';

            $subject = 'New Task Assigned';
            $email = $data['email'];
            $to = $email;
            $toTitle = 'New Task';
            $data['to'] = $to;
            $param = [
                'subject' => $subject,
                'from' => ['name' => $fromTitle, 'address' => $from],
                'view' => 'emails.task_assign_email_template',
                'data' => $data
            ];
            $to = ['name' => $toTitle, 'email' => $to];
            $to = (Object)$to;
             
              Mail::to($data['to'])->send(new SendMail($param));

}


public static function sendEmailToTaskAssigner($id,$status){  
  $user   = User::where('id','=',$id)->first();

  $data = array(
          'firstname' => $user->name,
          'lastname' => $user->lastname,
          'username' => $user->username,
          'email' => $user->email,
          'status'=>$status
          
        );


            $fromTitle = 'VKA CRM Team';
            $from =  'no_reply@veritaskapital.com';

            $subject = 'Task replied';
            $email = $data['email'];
            $to = $email;
            $toTitle = 'Task replied';
            $data['to'] = $to;
            $param = [
                'subject' => $subject,
                'from' => ['address' => $from,'name' => $fromTitle],
                'view' => 'emails.task_assign_reply_email_template',
                'data' => $data
            ];
            $to = ['name' => $toTitle, 'email' => $to];
            $to = (Object)$to;
             
              Mail::to($data['to'])->send(new SendMail($param));

}
        
}