<?php

namespace App\Http\Controllers\Site;


use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Routing\Route;
use App\Http\Controllers\Controller;
use App\Models\Agent;
use DB;
use Auth;


class AgentLoginController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
         
    
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */

   

       public function login()
    {
        return view('site/agent/login');
    }

    

       public function signup(Request $request)
    {

        return view('site/agent/register');
    }

       public function store(Request $request)
    {

        //dd($request);        
        $user = new Agent;
        $user->user_role = 2;
        $user->name = $request->name;
        $user->email = $request->email;
        $user->mobile = $request->mobile;
       
           $rules = $this->getRules($request, $user);
         if ($request->password != '' || $request->password_confirmation != '') {            
            if ($request->password != $request->password_confirmation) {
                $rules['password'] = 'required|min:6|confirmed';

            }
        }

        
        $this->validate($request, $rules);


        if ($request->password != '' && $request->password_confirmation != '') {
            if ($request->password == $request->password_confirmation) {
                $user->password = bcrypt($request->password);
            }
        }


        $user->save();
        return redirect()->route('agentlogin')->with('success', 'saved');
    }

       public function checkLogin(Request $request)
    {

        //dd($request);

    $this->validate($request, [
           'email'   => 'required|email',
           'password'  => 'required|alphaNum|min:3'
     ]);

         $user_data = array(
                'email'  => $request->get('email'),
                'password' => $request->get('password')
                
         );

         
        if(Auth::guard('agent')->attempt($user_data)) {           

            return redirect()->route('agent.dashboard.show')->with('success', 'saved');
           }
          else
         {
          return back()->with('error', 'These credentials do not match our records.');
         }

}


    
 public function getRules(Request $request, $admin)
    {
        $rules = ['name' => 'required'];
//        $rules['name'] = 'required|unique';
        //       $rules['email'] = 'required|unique';
        if ($admin) {
            if ($request->email && $admin->email != $request->email) {
                $rules['email'] = 'unique:users';
            }
        } else {
            $rules['email'] = 'unique:users';
        }
        return $rules;
    }


     public function showProfile() {
        $user = Agent::where('user_role','=',2)->where('email','=',auth()->user()->email)->first();       
        $page_title  = 'Agent Profile';
        return view('site/agent/profile', compact('user','page_title'));
        
    }


    public function profileUpdate(Request $request, $id) {        
        $user = Agent::where('id', '=', $id)->first();
               
        $user->name = $request->name;
        $user->email = $request->email;

        $rules = $this->getRules($request, $user);

        if ($request->p1 != '' || $request->p2 != '') {
            if ($request->p1 != $request->p2) {
                $rules['password'] = 'required|min:6';
            }
        }
        $this->validate($request, $rules);

        if ($request->p1 != '' && $request->p2 != '') {
            if ($request->p1 == $request->p2) {
                $user->password = bcrypt($request->p1);
            }
        }
        if ($request->hasFile('image')) {
            $rules['image'] = 'image|mimes:png,jpg,gif,jpeg';
        }
        
        //$user->password = bcrypt($request->p1);       

       
        $user->save();

        if ($request->hasFile('image')) {
            $image = $request->file('image');
            $fileName = time() . "_users_$user->id." . $image->getClientOriginalExtension();
            $image->move(public_path('uploads/site/users/'), $fileName);

            if ($user->image != 'photo.jpg' && is_file(public_path('uploads/site/users/' . $user->image))) {
                unlink(public_path('uploads/site/users/' . $user->image));
            }
            $user->avatar = $fileName;
        }

        $user->save();

        return redirect()->route('agent.profile.show')->with('success', 'Profile update successfully');

    }
}
