<?php



namespace App\Http\Controllers\Admin\Tasks;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Mail\SendMail;
use App\Models\Task;
use App\Models\User;
use App\Models\Agency;
use App\Models\Account;
use App\Models\Lead;
use App\Models\Note;
use App\Helpers\EmailHelper;
use Validator;
use Image;
use Auth;


class TaskController extends Controller
{

    public function index(Request $request){  
        
    $page_title = 'Tasks';   
    $start_date = $request->start_date;
    $stop_date = $request->stop_date;   
   $assigned_by = $request->assigned_by;
    
   if($request->search == 'Search'){
      if(isset($request->assigned_by)){
        $tasks      = Task::join('users', 'tasks.user_id', '=', 'users.id')
        ->whereBetween('tasks.created_at',[$start_date, $stop_date])
        ->where('tasks.assigned_by_user_name','like',"%{$request->assigned_by}%")
        ->select('tasks.*','users.name as assigned_username')
        ->get();
      }
      else{
        $tasks      = Task::join('users', 'tasks.user_id', '=', 'users.id')
        ->whereBetween('tasks.created_at',[$start_date, $stop_date])
        ->select('tasks.*','users.name as assigned_username')
        ->get();

      }
      }
      else{
        $tasks      = Task::join('users', 'tasks.user_id', '=', 'users.id')
        ->select('tasks.*','users.name as assigned_username')
        ->get();
      }
    return view('admin/task/index', compact('page_title', 'tasks','start_date','stop_date','assigned_by'));    
   }


    public function create(Request $request){                 
       $page_title = 'Add Task';
      // $users = User::where('id','!=',Auth::user()->id)->get();
        $users = User::get();
       $brokers = Agency::where('agency_category_id','=',1)->get();
       $customers = Account::get();
       return view('admin/task/add', compact('page_title','users','brokers','customers'));    
      }

     public function store(Request $request){ 
      
      $Task                = new Task;
      $Task->user_id       = $request->user_id;
      $Task->assigned_by_user_id = Auth::user()->id;
      $Task->assigned_by_user_name = Auth::user()->name;
      $Task->name          = $request->name;
      $Task->description   = $request->description;
      $Task->type          = $request->type;
      if($request->type == 'Broker'){
         $Task->task_type_name = implode(',', $request->task_type_name_broker); 
      }else if($request->type == 'Customer' ){
         $Task->task_type_name = implode(',', $request->task_type_name_customer); 
      }
     
      $Task->save();

      
      if ($request->hasFile('file')) {
            $image = $request->file('file');
            $fileName = time() . "tasks." . $image->getClientOriginalExtension();
            $image->move(public_path('uploads/site/tasks/'), $fileName);

            if ($Task->file != 'photo.jpg' && is_file(public_path('uploads/site/tasks/' . $Task->file))) {
                unlink(public_path('uploads/site/tasks/' . $Task->file));
            }
            $Task->file = $fileName;
            $Task->save();
        }

     EmailHelper::sendEmailToTaskUser($Task->id);
     return redirect()->route('admin.tasks.show')->with('success', 'Task Add Successfully.');

            
   }

     public function show($id) {
        $task = Task::where('id', '=', $id)->first(); 
      dd('stupid fool');
        //$users = User::where('id','!=',Auth::user()->id)->get();
         $users = User::get();
        $notes = Note::where('task_id','=',$id)
        ->join('users', 'tasks_notes.user_id', '=', 'users.id')
        ->select('tasks_notes.*','users.name as fullname')
        ->get();
        $brokers = Agency::where('agency_category_id','=',1)->get();
        $customers = Account::get();         
        return view('admin/task/edit', compact('task','users','notes','brokers','customers'));    
    }

     public function update(Request $request, $id) {
      //dd($request);
      $Task                = Task::where('id', '=', $id)->first();
      $Task->user_id       = $request->user_id;
      $Task->assigned_by_user_id = Auth::user()->id;
      $Task->assigned_by_user_name = Auth::user()->name;
      $Task->name          = $request->name;
      $Task->description   = $request->description;
      $Task->type          = $request->type;
      if($request->type == 'Broker'){
         $Task->task_type_name = implode(',', $request->task_type_name_broker); 
      }else if($request->type == 'Customer' ){
         $Task->task_type_name = implode(',', $request->task_type_name_customer); 
      }
      $Task->save();          
      return redirect()->route('admin.tasks.show')->with('success', 'Task Update Successfully .');
    }



   

     public function destroy($id) {
        $c = Task::find($id); 
        $c->delete(); //delete the User
        return redirect()->route('admin.tasks.show')->with('success', 'Task Delete Successfully.');
    }

      public function getAjaxResult(Request $request) {
        
        if($request->type === 'Broker'){

        return  Agency::where('agency_category_id','=', 1)->get();
        
        }else if($request->type === 'Customer'){
         return  Account::get();
         
        }
    }


    public function exportTasks(Request $request){
      $fileName="";
      $tasks=[];
      if($request->input('start_date')!==null && $request->input('stop_date')!==null){
          $fileName = 'tasksbtw-'.$request->input('start_date').'-'.$request->input('stop_date').'.csv'; 

          $tasks = Task::join('users', 'tasks.user_id', '=', 'users.id')
                      ->whereBetween('tasks.created_at',[$request->input('start_date'), $request->input('stop_date')])
                     ->select('tasks.*','users.name as assigned_username')
                     ->get(); 
      }
      else{
        $fileName = 'tasks.csv'; 

          $tasks = Task::join('users', 'tasks.user_id', '=', 'users.id')
                     ->select('tasks.*','users.name as assigned_username')
                     ->get(); 
      }
       $headers = array(
            "Content-type"        => "text/csv",
            "Content-Disposition" => "attachment; filename=$fileName",
            "Pragma"              => "no-cache",
            "Cache-Control"       => "must-revalidate, post-check=0, pre-check=0",
            "Expires"             => "0"
        );

           $columns = array('Subject', 'Assigned To User');

            $callback = function() use($tasks, $columns) {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columns);

            foreach ($tasks as $task) {
                
                $row['Subject']        = $task['name'];
                $row['Assigned To User']  = $task['assigned_username'];
                
               
            fputcsv($file, array( $row['Subject'], $row['Assigned To User']));
            }

            fclose($file);
        };

        
        
        return response()->stream($callback, 200, $headers);
    }

    
    
    

}

