<?php



namespace App\Http\Controllers\Admin\Staff;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Helpers\HeaderHelper;
use App\Helpers\EmailHelper;
use App\Mail\SendMail;
use App\Models\Customer;
use App\Models\User;
use App\Models\Lead;
use App\Models\Insurance;
use App\Models\Opportunity;
use App\Models\Sale;
use App\Models\Account;
use Validator;
use Image;
use Auth;


class AccountController extends Controller

{    

    public function index(Request $request){  
    $page_title = 'Accounts';  
    $accounts = Account::where('user_id','=',Auth::user()->id)->get(); 
    //dd($accounts);
    return view('admin/sales/accounts/index', compact('page_title', 'accounts'));    
   }


    public function convertToOpportunity(Request $request,$id){ 
      //dd($request);
      $Opportunity = new Opportunity;
      $Opportunity->user_id = Auth::user()->id;
      $Opportunity->lead_id = $request->lead_id;
      $Opportunity->insurance_id = $request->insurance;
      $Opportunity->insurance_name = $request->insurane_name;
      $Opportunity->price = $request->price;
      $Opportunity->expire = $request->expire;
      $Opportunity->save();
      
      return redirect()->route('staff.accounts.show')->with('success', 'Account Convert to Opportunity Successfully.');
    }

     public function store(Request $request){ 
     
       
   }

     public function show($id) {
     $accounts = Account::where('id','=',$id)->first();
     $insurances = Insurance::get();
     
    return view('admin/sales/accounts/edit', compact('accounts','insurances'));    
   
    }

     public function update(Request $request) {
      
       
    }

  

     public function destroy($id) {
      $c = Account::find($id); 
      $c->delete();
    return redirect()->route('staff.opportunity.show')->with('success', 'Account Delete Successfully.');
       
    }

    public function exportCSV(Request $request){
      $fileName = 'activity.csv'; 
      $foundflag = false;
      $array     = [];
      $i         = 0;   
   

       $accounts = Account::where('user_id','=',Auth::user()->id)->get();
     
       $headers = array(
            "Content-type"        => "text/csv",
            "Content-Disposition" => "attachment; filename=$fileName",
            "Pragma"              => "no-cache",
            "Cache-Control"       => "must-revalidate, post-check=0, pre-check=0",
            "Expires"             => "0"
        );

           $columns = array('Name', 'Product', 'Expire','Premium','Agency');

            $callback = function() use($accounts, $columns) {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columns);

            foreach ($accounts as $account) {
                
                $row['Name']          = $account->account_name;
                $row['Product']       = $account->insurance_name;
                $row['Expire']        = $account->expire;
                $row['Premium']       = $account->price;
                $row['Agency']        = $account->agency;
                
                
            fputcsv($file, array( $row['Name'], $row['Product'], $row['Expire'], $row['Premium'], $row['Agency']));
            }

            fclose($file);
        };

        
        
        return response()->stream($callback, 200, $headers);
    }
    
    

}

