<?php

    namespace App\Http\Controllers\Admin\Reports;

    use App\Http\Controllers\Controller;
    use Illuminate\Support\Facades\Mail;
    use App\Mail\SendMail;
    use Illuminate\Support\Facades\DB;



    class ReportController extends Controller
    {    
        private $last_week_monday = '';
	    private $last_week_saturday = '';

        public function __construct()
        {
            $this-> last_week_monday = date('Y-m-d',strtotime('monday last week'));
	        $this->last_week_saturday = date('Y-m-d',strtotime('saturday last week'));

        //     $this-> last_week_monday = '2023-06-01';
	       // $this->last_week_saturday = '2024-09-30';
        }

        public function sendWeeklyReport()
        {
            $results = DB::select("SELECT * FROM users WHERE status = '1' AND (address LIKE '%BUSINESS DEVELOPMENT%' AND (clo_id LIKE 'vkas%' OR clo_id LIKE 'ukss%')) ");
            if(count($results) > 0){              
                //$i = 0;
                foreach ($results as $records) {
                    //if($i > 2){break;}
                    $this->weeklyAutoReport($records->id, $records->email, $records->lastname.' '.$records->name);
                    //$this->weeklyAutoReport($records->id, 'pbalarabe@veritaskapital.com', $records->lastname.' '.$records->name);
                    
                    //$i++;
                }
            }
        }

        private function weeklyAutoReport($user_id, $user_email, $user_name)
        {
            $data = array(
                'name' => ''.$user_name,
                'email' => ''.$user_email,
                'duration' => '  '.$this->last_week_monday.' to '.$this->last_week_saturday.'',
                'physical_call' => $this->getCallActivities($user_id, 'Physical'),
                'phone_call' => $this->getCallActivities($user_id, 'Call'),
                'leads_created' => $this->getLeadsCreated($user_id),
                'sales_made' => $this->getSalesMade($user_id),
                'opportunities_created' => $this->getOpportunitiesCreated($user_id),
                'vka_rides' => $this->getVkaRidesCreated($user_id),
                'last_usage' => $this->getLastDateOfUsage($user_id)
            );
            //'vka_rides' => $this->getVkaRidesCreated($user_id),
            $param = [
                'subject' =>'CRM Weekly Report for '.$this->last_week_monday.' - '.$this->last_week_saturday,
                'from' => ['name' => 'CRM Weekly Report ', 'address' => 'no_reply@veritaskapital.com'],
                'view' => 'templates/crm_weekly_report',
                'name' => 'CRM Weekly Report',
                'address' =>  'no_reply@veritaskapital.com',
                'data' => $data
            ];

           Mail::to($user_email)->bcc(['ailiyasu@veritaskapital.com', 'conaji@veritaskapital.com'])->send(new SendMail($param));
           //Mail::to("aisa@veritaskapital.com")->bcc(['conaji@veritaskapital.com','pbalarabe@veritaskapital.com' ])->send(new SendMail($param));
        }
        
        public function testCronJob()
        {
            $data = array(
                'name' => '',
                'email' => '',
                'duration' => '  '.$this->last_week_monday.' to '.$this->last_week_saturday.'',
                'physical_call' => 0,
                'phone_call' => 0,
                'vka_rides' => 0,
                'leads_created' => 0,
                'sales_made' => 0,
                'opportunities_created' => 0,
                'last_usage' => 0
            );
            
            $param = [
                'subject' =>'CRM Weekly Report for '.$this->last_week_monday.' - '.$this->last_week_saturday,
                'from' => ['name' => 'CRM Weekly Report ', 'address' => 'no_reply@veritaskapital.com'],
                'view' => 'templates/crm_weekly_report',
                'name' => 'CRM Weekly Report',
                'address' =>  'no_reply@veritaskapital.com',
                'data' => $data
            ];

           Mail::to('aisa@veritaskapital.com')->bcc('pbalarabe@veritaskapital.com')->send(new SendMail($param));
        }

        private function getCallActivities($user_id, $mode_of_activity)
        {
            $total = 0;

            $results = DB::select("SELECT COUNT(*) AS total FROM callings WHERE user_id = '".$user_id."' AND mode_of_activity = '".$mode_of_activity."' AND DATE(created_at) BETWEEN '".$this->last_week_monday."' AND '".$this->last_week_saturday."' group by week(created_at)");
            if(count($results) > 0){
                $total = $results[0]->total;
            }
            //dd($results);
            return $total;
        }

        private function getVkaRidesCreated()
        {
            return '0';
        }

        private function getLeadsCreated($user_id)
        {
            $total = '0';

            $results = DB::select("SELECT COUNT(*) AS total, user_id, created_at FROM leads WHERE user_id = '".$user_id."' AND DATE(created_at) BETWEEN '".$this->last_week_monday."' AND '".$this->last_week_saturday."' group by week(created_at)");
            if(count($results) > 0){
                 $total = $results[0]->total;
            }

            return $total;
        }

        private function getSalesMade($user_id)
        {
            $total = 0;

             $results = DB::select("SELECT COUNT(*) AS total, user_id, created_at FROM sales WHERE user_id = '".$user_id."' AND DATE(created_at) BETWEEN '".$this->last_week_monday."' AND '".$this->last_week_saturday."' group by week(created_at)");
            if(count($results) > 0){
                 $total = $results[0]->total;
            }

            return $total;
        }

        private function getOpportunitiesCreated($user_id)
        {
            $total = '0';

             $results = DB::select("SELECT COUNT(*) AS total, user_id, created_at FROM opportunities WHERE user_id = '".$user_id."' AND DATE(created_at) BETWEEN '".$this->last_week_monday."' AND '".$this->last_week_saturday."' group by week(created_at)");
            if(count($results) > 0){
                 $total = $results[0]->total;
            }

            return $total;
        }

        private function getLastDateOfUsage($user_id)
        {
            $last_date = '0';

            $results = DB::table('callings')->where('user_id', $user_id)->latest('created_at')->first();
            if($results){
                $last_date = $results->created_at;
            }

            return $last_date;
        }
        
        //weekly report functions
        private function getWeeklyCallActivities()
        {
            $total = 0;

            $results = DB::select("SELECT COUNT(*) AS total FROM callings INNER JOIN users on users.id = callings.user_id
                            WHERE DATE(callings.created_at) BETWEEN '".$this->last_week_monday."' AND '".$this->last_week_saturday."' 
                            AND users.status = '1' AND (users.address LIKE '%BUSINESS DEVELOPMENT%' AND (users.clo_id LIKE 'vkas%' OR clo_id LIKE 'ukss%'))
                            group by week(callings.created_at)"
                    );
            if(count($results) > 0){
                $total = $results[0]->total;
            }
            //dd($results);
            return $total;
        }
        
        private function getWeeklyLeadsCreated()
        {
            $total = '0';

            $results = DB::select("SELECT COUNT(*) AS total, user_id, leads.created_at 
                            FROM leads INNER JOIN users on users.id = leads.user_id
                            WHERE DATE(leads.created_at) 
                            BETWEEN '".$this->last_week_monday."' AND '".$this->last_week_saturday."' 
                            AND users.status = '1' AND (users.address LIKE '%BUSINESS DEVELOPMENT%' AND (users.clo_id LIKE 'vkas%' OR clo_id LIKE 'ukss%'))
                            group by week(leads.created_at)"
                        );
            if(count($results) > 0){
                 $total = $results[0]->total;
            }

            return $total;
        }

        private function getWeeklySalesMade()
        {
            $total = 0;

             $results = DB::select("SELECT COUNT(*) AS total, user_id, sales.created_at 
                            FROM sales INNER JOIN users on users.id = sales.user_id
                            WHERE price > 0 AND DATE(sales.created_at) 
                            BETWEEN '".$this->last_week_monday."' AND '".$this->last_week_saturday."' 
                            AND users.status = '1' AND (users.address LIKE '%BUSINESS DEVELOPMENT%' AND (users.clo_id LIKE 'vkas%' OR clo_id LIKE 'ukss%'))
                            group by week(sales.created_at)"
                        );
            if(count($results) > 0){
                 $total = $results[0]->total;
            }

            return $total;
        }

        private function getWeeklyOpportunitiesCreated()
        {
            $total = '0';

             $results = DB::select("SELECT COUNT(*) AS total, user_id, opportunities.created_at 
                            FROM opportunities INNER JOIN users on users.id = opportunities.user_id
                            WHERE DATE(opportunities.created_at) 
                            BETWEEN '".$this->last_week_monday."' AND '".$this->last_week_saturday."' 
                            AND users.status = '1' AND (users.address LIKE '%BUSINESS DEVELOPMENT%' AND (users.clo_id LIKE 'vkas%' OR clo_id LIKE 'ukss%'))
                            group by week(opportunities.created_at)"
                        );
            if(count($results) > 0){
                 $total = $results[0]->total;
            }

            return $total;
        }

        private function getWeeklyRevenue()
        {
            $total = 0;

             $results = DB::select("SELECT SUM(price) AS total, user_id, sales.created_at 
                            FROM sales INNER JOIN users on users.id = sales.user_id
                            WHERE DATE(sales.created_at) 
                            BETWEEN '".$this->last_week_monday."' AND '".$this->last_week_saturday."' 
                            AND users.status = '1' AND (users.address LIKE '%BUSINESS DEVELOPMENT%' AND (users.clo_id LIKE 'vkas%' OR clo_id LIKE 'ukss%'))
                            group by week(sales.created_at)"
                        );
            if(count($results) > 0){
                 $total = $results[0]->total;
            }

            return $total;
        }
        
        public function getStaffWeeklyAnalyticsReport()
        {
            $activities = $this->getWeeklyCallActivities(); 
            $opportunities = $this->getWeeklyOpportunitiesCreated(); 
            $sales = $this->getWeeklySalesMade(); 
            $leads = $this->getWeeklyLeadsCreated(); 
            $revenue = $this->getWeeklyRevenue(); 
             $email = "snwachukwu@veritaskapital.com";
            //$email = "aisa@veritaskapital.com";
            $run_rate = ($opportunities > 0) ? (($sales / $opportunities) * 100) : 0;
            $staff_activities = $this->getWeeklyStaffActivities();
            
            $data = [
                'activities' => $activities,
                'opportunities' => $opportunities,
                'sales' => $sales,
                'leads' => $leads,
                'revenue' => $revenue,
                'run_rate' => $run_rate,
                'staff_activities' => $staff_activities,
            ];
            
            $msg = "
                <h3>Dear Ma,</h3>
                <p>
                    Kindly find below company wide summary of Business Development activities for the selected period in the subject:
                        <h4>Opportunities Created:</h4>". $opportunities ."<br>
                        <h4>Leads Generated:</h4>". $leads ."<br>
                        // <h4>Sales Closed:</h4>". $sales ."<br>
                        <h4>Revenue Generated:</h4>&#8358; ". number_format($revenue, 2) ."<br>
                </p>
            ";
            
            $subject = 'CRM Weekly Analytics Report for '.$this->last_week_monday.' to '.$this->last_week_saturday.'';
            
             Mail::send('staff_activities_analytics_email_template', $data, function ($message) use ($email, $subject) {
                $message->to($email, 'Recipient Name')->subject($subject);
                
                // CC the rest of the recipients
                $ccRecipients = [
                    'sadekeye@veritaskapital.com',
                    'adaobinwakuche@veritaskapital.com',
                    'internalaudit@veritaskapital.com',
                ];
                
                // BCC the rest of the recipients
                $bccRecipients = [
                     'ailiyasu@veritaskapital.com',
                     //'figunsabi@veritaskapital.com',
                    // 'fyunusa@veritaskapital.com',
                    //'conaji@veritaskapital.com',
                    'aisa@veritaskapital.com',
                ];
            
                $message->cc($ccRecipients, 'Recipient Name');
                $message->bcc($bccRecipients, 'Recipient Name');
    
            });
            
            echo "Successful";
        }
        
        public function getBranchWeeklyAnalyticsReport()
        {
            $activities = $this->getWeeklyCallActivities(); 
            $opportunities = $this->getWeeklyOpportunitiesCreated(); 
            $sales = $this->getWeeklySalesMade(); 
            $leads = $this->getWeeklyLeadsCreated(); 
            $revenue = $this->getWeeklyRevenue(); 
            $email = "snwachukwu@veritaskapital.com";
            //$email = "pbalarabe@veritaskapital.com";
            $run_rate = ($opportunities > 0) ? (($sales / $opportunities) * 100) : 0;
            $staff_activities = $this->getWeeklyStaffActivities();
            $branch_activities = $this->getWeeklyBranchActivities();
            
            $data = [
                'activities' => $activities,
                'opportunities' => $opportunities,
                'sales' => $sales,
                'leads' => $leads,
                'revenue' => $revenue,
                'run_rate' => $run_rate,
                'branch_activities' => $branch_activities,
            ];
            
            $subject = 'Branch CRM Weekly Analytics Report for '.$this->last_week_monday.' to '.$this->last_week_saturday.'';
            
             Mail::send('branch_activities_analytics_email_template', $data, function ($message) use ($email, $subject) {
                $message->to($email, 'Recipient Name')->subject($subject);
                
                // CC the rest of the recipients
                $ccRecipients = [
                    'sadekeye@veritaskapital.com',
                    'adaobinwakuche@veritaskapital.com',
                    'internalaudit@veritaskapital.com',
                ];
                
                // BCC the rest of the recipients
                $bccRecipients = [
                    'ailiyasu@veritaskapital.com',
                    'figunsabi@veritaskapital.com',
                    'fyunusa@veritaskapital.com',
                    'conaji@veritaskapital.com',
                    'aisa@veritaskapital.com',
                    'pbalarabe@veritaskapital.com',
                ];
            
                $message->cc($ccRecipients, 'Recipient Name');
                $message->bcc($bccRecipients, 'Recipient Name');
    
            });
            
            echo "Successful";
        }

        public function getWeeklyAnalyticsReportView()
        {
            
            $opportunities = $this->getWeeklyOpportunitiesCreated();
            $sales = $this->getWeeklySalesMade(); 
            $leads = $this->getWeeklyLeadsCreated(); 
            $revenue = $this->getWeeklyRevenue(); 
            $email = "pbalarabe@veritaskapital.com";
            $run_rate = ($opportunities > 0) ? (($sales / $opportunities) * 100) : 0;
            $breakdown = $this->getWeeklyBranchActivities();
            
            $data = [
                'opportunities' => $opportunities,
                'sales' => $sales,
                'leads' => $leads,
                'revenue' => $revenue,
                'run_rate' => $run_rate,
                'breakdown' => $breakdown,
            ];
            
            //dd($breakdown);
            
            return view('analytics_email_template', $data);
        }
        
        private function getWeeklyStaffActivities()
        {
            // Fetch data from the database
            $results = DB::select("
                SELECT users.id, users.name, users.lastname, 
                       COALESCE(COUNT(DISTINCT callings.id), 0) AS calling_count, 
                       COALESCE(COUNT(DISTINCT sales.id), 0) AS sales_count, 
                       COALESCE(COUNT(DISTINCT leads.id), 0) AS leads_count, 
                       COALESCE(COUNT(DISTINCT opportunities.id), 0) AS opportunities_count
                FROM users
                LEFT JOIN callings ON users.id = callings.user_id AND DATE(callings.created_at) BETWEEN ? AND ?
                LEFT JOIN sales ON users.id = sales.user_id AND DATE(sales.created_at) BETWEEN ? AND ? AND price > 0
                LEFT JOIN leads ON users.id = leads.user_id AND DATE(leads.created_at) BETWEEN ? AND ?
                LEFT JOIN opportunities ON users.id = opportunities.user_id AND DATE(opportunities.created_at) BETWEEN ? AND ?
                WHERE users.status = '1' AND (users.address LIKE '%BUSINESS DEVELOPMENT%' AND (users.clo_id LIKE 'vkas%' OR clo_id LIKE 'ukss%'))
                GROUP BY users.id, users.name
                ORDER BY calling_count DESC, users.name 
            ", [
                $this->last_week_monday, $this->last_week_saturday, // Callings date range
                $this->last_week_monday, $this->last_week_saturday, // Sales date range
                $this->last_week_monday, $this->last_week_saturday, // Leads date range
                $this->last_week_monday, $this->last_week_saturday  // Opportunities date range
            ]);
        
            return $results;
        }
        
        private function getWeeklyStaffProduction()
        {
            // Fetch data from the database
            $results = DB::select("
                SELECT users.id, users.name, users.lastname, 
                       COALESCE(COUNT(DISTINCT callings.id), 0) AS calling_count, 
                       COALESCE(COUNT(DISTINCT sales.id), 0) AS sales_count, 
                       COALESCE(COUNT(DISTINCT leads.id), 0) AS leads_count, 
                       COALESCE(COUNT(DISTINCT opportunities.id), 0) AS opportunities_count
                FROM users
                LEFT JOIN callings ON users.id = callings.user_id AND DATE(callings.created_at) BETWEEN ? AND ?
                LEFT JOIN sales ON users.id = sales.user_id AND DATE(sales.created_at) BETWEEN ? AND ? AND price > 0
                LEFT JOIN leads ON users.id = leads.user_id AND DATE(leads.created_at) BETWEEN ? AND ?
                LEFT JOIN opportunities ON users.id = opportunities.user_id AND DATE(opportunities.created_at) BETWEEN ? AND ?
                WHERE users.status = '1' AND (users.address LIKE '%BUSINESS DEVELOPMENT%' AND (users.clo_id LIKE 'vkas%' OR clo_id LIKE 'ukss%'))
                GROUP BY users.id, users.name
                ORDER BY calling_count DESC, users.name 
            ", [
                $this->last_week_monday, $this->last_week_saturday, // Callings date range
                $this->last_week_monday, $this->last_week_saturday, // Sales date range
                $this->last_week_monday, $this->last_week_saturday, // Leads date range
                $this->last_week_monday, $this->last_week_saturday  // Opportunities date range
            ]);
        
            return $results;
        }
        
        private function getWeeklyBranchActivities()
        {
            // Fetch data from the database
            $results = DB::select("
                SELECT users.user_branch, 
                       COALESCE(COUNT(DISTINCT callings.id), 0) AS calling_count, 
                       COALESCE(COUNT(DISTINCT sales.id), 0) AS sales_count, 
                       COALESCE(COUNT(DISTINCT leads.id), 0) AS leads_count, 
                       COALESCE(COUNT(DISTINCT opportunities.id), 0) AS opportunities_count
                FROM users
                LEFT JOIN callings ON users.id = callings.user_id AND DATE(callings.created_at) BETWEEN ? AND ?
                LEFT JOIN sales ON users.id = sales.user_id AND DATE(sales.created_at) BETWEEN ? AND ? AND price > 0
                LEFT JOIN leads ON users.id = leads.user_id AND DATE(leads.created_at) BETWEEN ? AND ?
                LEFT JOIN opportunities ON users.id = opportunities.user_id AND DATE(opportunities.created_at) BETWEEN ? AND ?
                WHERE users.user_branch IS NOT NULL AND users.status = '1' AND (users.address LIKE '%BUSINESS DEVELOPMENT%' AND (users.clo_id LIKE 'vkas%' OR clo_id LIKE 'ukss%'))
                GROUP BY users.user_branch
                ORDER BY calling_count DESC
            ", [
                $this->last_week_monday, $this->last_week_saturday, // Callings date range
                $this->last_week_monday, $this->last_week_saturday, // Sales date range
                $this->last_week_monday, $this->last_week_saturday, // Leads date range
                $this->last_week_monday, $this->last_week_saturday  // Opportunities date range
            ]);
        
            return $results;
        }




    }

?>