<?php



namespace App\Http\Controllers\Admin\Reports;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Helpers\HeaderHelper;
use App\Mail\SendMail;
use App\Models\Customer;
use App\Models\User;
use App\Models\Lead;
use App\Models\Insurance;
use App\Models\Opportunity;
use App\Models\Sale;
use Validator;
use Image;
use Auth;


class OpportunityController extends Controller

{    

    public function index(Request $request){     
    $page_title = 'Opportunities'; 
      $assigned_by =$request->assigned_by;
      $start_date = $request->start_date;
      $stop_date = $request->stop_date; 
    if($request->search == 'Search'){
      if(isset($request->assigned_by)){
        $opportunities = Opportunity::join('leads', 'opportunities.lead_id', '=', 'leads.id')
                    ->select('opportunities.*','leads.*','leads.firstname as name','leads.lastname as lname')
                    ->whereBetween('opportunities.created_at',[$request->start_date, $request->stop_date])
                    ->where('leads.assigned_by_user_name','like',"%{$request->assigned_by}%")
                    ->get();
          
      }
      else{
        $opportunities = Opportunity::whereBetween('opportunities.created_at',[$request->start_date, $request->stop_date])
                    ->join('leads', 'opportunities.lead_id', '=', 'leads.id')
                    ->select('opportunities.*','leads.*','leads.firstname as name','leads.lastname as lname')
                    ->get();
      }

    }else{

    $opportunities = Opportunity::join('leads', 'opportunities.lead_id', '=', 'leads.id')
                    ->select('opportunities.*','leads.*','leads.firstname as name','leads.lastname as lname')
                    ->get();

  }
    return view('admin/reports/opportunities/index', compact('page_title', 'opportunities','assigned_by','start_date','stop_date'));    
   }


    public function create(Request $request){                 
         
      }

     public function store(Request $request){ 


            
   }

     public function show($id) {

      $opportunities = Opportunity::where('id','=',$id)->first(); 
      $insurances = Insurance::get();
      return view('admin/reports/opportunities/edit', compact('opportunities','insurances')); 
        
    }

     public function update(Request $request, $id) {
      
      $Sale = new Sale;
      $Sale->user_id = Auth::user()->id;
      $Sale->lead_id = $request->lead_id;
      $Sale->assigned_by_user_id = Lead::where('id','=',$request->lead_id)->pluck('assigned_by_user_id')->first();
      $Sale->insurance_id = $request->insurance;
      $Sale->insurance_name = $request->insurane_name;
      $Sale->price = $request->price;
      $Sale->expire = $request->expire;
      $Sale->save();
      $Lead = Lead::where('id', '=', $request->lead_id)->first();  
      $Lead->status = 'Progress';
      $Lead->save();
      
      self::destroy($id);
      return redirect()->route('staff.sales.create',$Sale->id)->with('success', 'Added Successfully.');
   
    }  

     public function destroy($id) {
      $c = Opportunity::find($id); 
      $c->delete();
        return redirect()->route('admin.reports.opportunity.show')->with('success', 'Opportunity Delete Successfully.');
       
    }

    public function exportCsv(Request $request){
      if($request->input('start_date')!==null && $request->input('stop_date')!==null){
            
        $fileName = 'opportunities-'.$request->input('start_date').'and'.$request->input('stop_date').'.csv'; 
        $foundflag = false;
        $array     = [];
        $i         = 0;   
        $opportunity = Opportunity::join('leads', 'opportunities.lead_id', '=', 'leads.id')
            ->whereBetween('opportunities.created_at',[$request->input('start_date'),$request->input('stop_date')])
            ->select('opportunities.*','leads.*','leads.firstname as name')
            ->get(); 

        $headers = array(
            "Content-type"        => "text/csv",
            "Content-Disposition" => "attachment; filename=$fileName",
            "Pragma"              => "no-cache",
            "Cache-Control"       => "must-revalidate, post-check=0, pre-check=0",
            "Expires"             => "0"
        );

           $columns = array('Lead','Assigned By','Product','Expire Date','Premium');

      $callback = function() use($opportunity, $columns) {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columns);
            // dd("if",$opportunities);
            foreach ($opportunity as $account) {
              $row['Lead']      = $account->name.' '.$account->lname;
              $row['Assigned By'] = $account->assigned_by_user_name;
              $row['Product']     = $account->insurance_name;
              $row['Expire Date']   = $account->expire;
              $row['Premium']    = number_format($account->price, );
                
            fputcsv($file, array( $row['Lead'], $row['Assigned By'], $row['Product'], $row['Expire Date'], $row['Premium']));
            }

            fclose($file);
        };

    }
    else{
        $fileName = 'opportunities.csv'; 
        $foundflag = false;
        $array     = [];
        $i         = 0;   
        $opportunity = Opportunity::join('leads', 'opportunities.lead_id', '=', 'leads.id')
          ->select('opportunities.*','leads.*','leads.firstname as name')
          ->get();
        
        $headers = array(
            "Content-type"        => "text/csv",
            "Content-Disposition" => "attachment; filename=$fileName",
            "Pragma"              => "no-cache",
            "Cache-Control"       => "must-revalidate, post-check=0, pre-check=0",
            "Expires"             => "0"
        );

            $columns = array('Lead','Assigned By','Product','Expire Date','Premium');

        $callback = function() use($opportunity, $columns) {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columns);
            // dd("else",$opportunity);
            foreach ($opportunity as $account) {
              $row['Lead']      = $account->name.' '.$account->lname;
              $row['Assigned By'] = $account->assigned_by_user_name;
              $row['Product']     = $account->insurance_name;
              $row['Expire Date']   = $account->expire;
              $row['Premium']    = number_format($account->price, );
                
              fputcsv($file, array( $row['Lead'], $row['Assigned By'], $row['Product'], $row['Expire Date'], $row['Premium']));
            }

            fclose($file);
        };


        }
      
      return response()->stream($callback, 200, $headers);

    }

    
    
    

}

