<?php



namespace App\Http\Controllers\Admin\Reports;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Helpers\HeaderHelper;
use App\Mail\SendMail;
use App\Models\Customer;
use App\Models\User;
use App\Models\Lead;
use Validator;
use Image;



class LeadController extends Controller

{    

    public function index(Request $request){     
    $page_title = 'Leads'; 
      $start_date = $request->start_date;
      $stop_date = $request->stop_date;    
      $assigned_by = $request->assigned_by;
      if($request->search == 'Search'){
        if(isset($request->assigned_by)){
            $leads = Lead::whereBetween('leads.created_at',[$start_date, $stop_date])->where('leads.assigned_by_user_name','like',"%{$assigned_by}%")->get(); 
        }
        else{
            $leads = Lead::whereBetween('leads.created_at',[$start_date, $stop_date])->get(); 
        }
        
      }else{

        $leads = Lead::get(); 
      
      }

    return view('admin/reports/leads/index', compact('page_title', 'leads','start_date','stop_date','assigned_by'));    
   }


    public function create(Request $request){ 
                
       $page_title = 'Add Customer';
       $states = HeaderHelper::states();
       return view('admin/reports/add', compact('page_title','states'));    
      }

     public function store(Request $request){ 

      $Customer = new Customer;
      $Customer->username = $request->username;
      $Customer->firstname = $request->firstname;
      $Customer->lastname = $request->lastname;
      $Customer->email = $request->email;
      $Customer->password = Hash::make($request->password);
      $Customer->phone_one = $request->phone_one;
      $Customer->phone_two = $request->phone_two;
      $Customer->phone_three = $request->phone_three;

      $Customer->address_one = $request->address_one;
      $Customer->address_two = $request->address_two;
      $Customer->address_three = $request->address_three;
      $Customer->address_four = $request->address_four;

      $Customer->area = $request->area;
      $Customer->state = $request->state;
      $Customer->postcode = $request->postcode;
      $Customer->models = $request->models;
      $Customer->serial_no = $request->serial_no;
      $Customer->remarks = $request->remarks;
      $Customer->purchase_date = $request->purchase_date;
      $Customer->status = $request->get('status',0);

      $Customer->save();

      if ($request->hasFile('image')) {
            $image = $request->file('image');
            $fileName = time() . "customer." . $image->getClientOriginalExtension();
            $image->move(public_path('uploads/site/customers/'), $fileName);

            if ($Customer->image != 'photo.jpg' && is_file(public_path('uploads/site/customers/' . $Customer->image))) {
                unlink(public_path('uploads/site/customers/' . $Customer->image));
            }
            $Customer->image = $fileName;
            $Customer->save();
        }

        $data = array(

       'name' => $request->firstname.' '.$request->lastname,
       'email' => $request->email,
       'username' => $request->username,
       'password' => $request->password       

    );

          $param = [
                'subject' => 'CRM: New Customer Registration.',
                'from' => ['name' => env('MAIL_FROM_NAME'), 'address' => env('MAIL_FROM_ADDRESS')],
                'view' => 'email_template',
                'data' => $data
            ];

     Mail::to($data['email'])->send(new SendMail($param));
     return redirect()->route('admin.reports.show')->with('success', 'Customer Add Successfully.');

            
   }

     public function show($id) {
        $customer = Customer::where('id', '=', $id)->first(); 
        $states = HeaderHelper::states();       
        return view('admin/reports/edit', compact('customer','states'));    
    }

     public function update(Request $request, $id) {
      $Customer = Customer::where('id', '=', $id)->first();
      $Customer->username = $request->username;
      $Customer->firstname = $request->firstname;
      $Customer->lastname = $request->lastname;
      $Customer->email = $request->email;
      $Customer->password = Hash::make($request->password);
      $Customer->phone_one = $request->phone_one;
      $Customer->phone_two = $request->phone_two;
      $Customer->phone_three = $request->phone_three;

      $Customer->address_one = $request->address_one;
      $Customer->address_two = $request->address_two;
      $Customer->address_three = $request->address_three;
      $Customer->address_four = $request->address_four;

      $Customer->area = $request->area;
      $Customer->state = $request->state;
      $Customer->postcode = $request->postcode;
      $Customer->models = $request->models;
      $Customer->serial_no = $request->serial_no;
      $Customer->remarks = $request->remarks;
      $Customer->purchase_date = $request->purchase_date;
      $Customer->status = $request->get('status',0);

      $Customer->save();
      if ($request->hasFile('image')) {
            $image = $request->file('image');
            $fileName = time() . "customer." . $image->getClientOriginalExtension();
            $image->move(public_path('uploads/site/customers/'), $fileName);

            if ($Customer->image != 'photo.jpg' && is_file(public_path('uploads/site/customers/' . $Customer->image))) {
                unlink(public_path('uploads/site/customers/' . $Customer->image));
            }
            $Customer->image = $fileName;
            $Customer->save();
        }            

      

    return redirect()->route('admin.reports.show')->with('success', 'Customer Update Successfully .');
    }



   

     public function destroy($id) {
        $c = Customer::find($id); 
        $c->delete(); //delete the User
        return redirect()->route('admin.reports.show')->with('success', 'Lead Delete Successfully.');
    }

    
    public function exportCSV(Request $request){
        
        if($request->input('start_date')!==null && $request->input('stop_date')!==null){
            
            $fileName = 'lead-'.$request->input('start_date').'and'.$request->input('stop_date').'.csv'; 
            $foundflag = false;
            $array     = [];
            $i         = 0;   
            $leads = Lead::join('users', 'leads.user_id', '=', 'users.id')
            ->whereBetween('leads.created_at',[$request->input('start_date'),$request->input('stop_date')])
            ->select('leads.*','users.name as staffname')
            ->get(); 

            $headers = array(
                "Content-type"        => "text/csv",
                "Content-Disposition" => "attachment; filename=$fileName",
                "Pragma"              => "no-cache",
                "Cache-Control"       => "must-revalidate, post-check=0, pre-check=0",
                "Expires"             => "0"
            );
    
               $columns = array('Assigned By', 'Name', 'Company','Company/Lead Type','Status');
    
          $callback = function() use($leads, $columns) {
                $file = fopen('php://output', 'w');
                fputcsv($file, $columns);
    
                foreach ($leads as $lead) {
                    
                    $row['Assigned By']          = $lead->assigned_by_user_name;
                    $row['Name']                 = $lead->firstname.' '.$lead->lastname;
                    $row['Company']              = $lead->nature_of_organisation;
                    $row['Company/Lead Type']    = $lead->lead_type;
                    $row['Status']               = $lead->status;
                    
                    
                fputcsv($file, array( $row['Assigned By'], $row['Name'], $row['Company'], $row['Company/Lead Type'], $row['Status']));
                }
    
                fclose($file);
            };
   
        }
        else{
            $fileName = 'lead.csv'; 
            $foundflag = false;
            $array     = [];
            $i         = 0;   
            $leads = Lead::join('users', 'leads.user_id', '=', 'users.id')
            ->select('leads.*','users.name as staffname')
            ->get(); 
    
    
            //  $assignedStaffsLists = UserHelper::getAssignStaffsUserList(Auth::user()->id);
            
        //     if(is_object ($assignedStaffsLists)){
    
        //     foreach ($assignedStaffsLists as $key => $value) {
    
        //   $leads = Lead::join('users', 'leads.user_id', '=', 'users.id')
        //           ->select('leads.*','users.name as staffname')
        //           ->get(); 
            
        //       }
    
        //     }
        
            
            $headers = array(
                "Content-type"        => "text/csv",
                "Content-Disposition" => "attachment; filename=$fileName",
                "Pragma"              => "no-cache",
                "Cache-Control"       => "must-revalidate, post-check=0, pre-check=0",
                "Expires"             => "0"
            );
    
                $columns = array('Assigned By', 'Name', 'Company','Company/Lead Type','Status');
    
            $callback = function() use($leads, $columns) {
                $file = fopen('php://output', 'w');
                fputcsv($file, $columns);
    
                foreach ($leads as $lead) {
                    
                    $row['Assigned By']          = $lead->assigned_by_user_name;
                    $row['Name']                 = $lead->firstname.' '.$lead->lastname;
                    $row['Company']              = $lead->nature_of_organisation;
                    $row['Company/Lead Type']    = $lead->lead_type;
                    $row['Status']               = $lead->status;
                    
                    
                fputcsv($file, array( $row['Assigned By'], $row['Name'], $row['Company'], $row['Company/Lead Type'], $row['Status']));
                }
    
                fclose($file);
            };
    

            }
          
          
          return response()->stream($callback, 200, $headers);
      }
    

}

