<?php



namespace App\Http\Controllers\Admin\Reports;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Helpers\HeaderHelper;
use App\Mail\SendMail;
use App\Models\Document;
use Validator;
use Image;
use Auth;



class DocumentController extends Controller

{    

    public function index(Request $request){     
    $page_title = 'Document';    
    $documents = Document::get();
    return view('admin/reports/document/index', compact('page_title', 'documents'));    
   }


    public function create(Request $request){            
       $page_title = 'Add Document';
       $types = ['mailmerge'=>'Mail Merge','eula'=>'EULA','nda'=>'NDA','license'=>'License Agreement'];
       $categories = ['Marketing'=>'Marketing','Knowledege Base'=>'Knowledege Base','Sales'=>'Sales'];
       $subcategories = ['Marketing Collateral'=>'Marketing Collateral','Product Brochures'=>'Product Brochures','FAQ'=>'FAQ'];
       return view('admin/reports/document/add', compact('page_title','types','categories','subcategories'));    
      }

     public function store(Request $request){ 

      $Document = new Document;
      $Document->name = $request->name;
      $Document->type = $request->type;
      $Document->publish_date = $request->publish_date;      
      $Document->expire_date = $request->expire_date;
      $Document->category_id = $request->category_id;  
      $Document->category_name = $request->category_name;
      $Document->sub_category_id = $request->sub_category_id;  
      $Document->sub_category_name = $request->sub_category_name;        
      $Document->description = $request->description;      
      $Document->status = $request->get('status',0);
      $Document->save();

       if ($request->hasFile('image')) {
            $image = $request->file('image');
            $fileName = time() . "customer." . $image->getClientOriginalExtension();
            $image->move(public_path('uploads/admin/documents/'), $fileName);

            if ($Document->image != 'photo.jpg' && is_file(public_path('uploads/admin/documents/' . $Document->image))) {
                unlink(public_path('uploads/admin/documents/' . $Document->image));
            }
            $Document->image = $fileName;
            $Document->save();
        }
      return redirect()->route('admin.documents.show')->with('success', 'Document Add Successfully.');

            
   }

     public function show($id) {
       $document = Document::where('id', '=', $id)->first(); 
       $types = ['mailmerge'=>'Mail Merge','eula'=>'EULA','nda'=>'NDA','license'=>'License Agreement'];
       $categories = ['Marketing'=>'Marketing','Knowledege Base'=>'Knowledege Base','Sales'=>'Sales'];
       $subcategories = ['Marketing Collateral'=>'Marketing Collateral','Product Brochures'=>'Product Brochures','FAQ'=>'FAQ'];
        return view('admin/reports/document/edit', compact('document','types','categories','subcategories'));    
    }

     public function update(Request $request, $id) {
      
      $Document = Document::where('id', '=', $id)->first();
      $Document->name = $request->name;
      $Document->type = $request->type;
      $Document->publish_date = $request->publish_date;      
      $Document->expire_date = $request->expire_date;
      $Document->category_id = $request->category_id;  
      $Document->category_name = $request->category_name;
      $Document->sub_category_id = $request->sub_category_id;  
      $Document->sub_category_name = $request->sub_category_name;        
      $Document->description = $request->description;      
      $Document->status = $request->get('status',0);
      $Document->save();  

       if ($request->hasFile('image')) {
            $image = $request->file('image');
            $fileName = time() . "customer." . $image->getClientOriginalExtension();
            $image->move(public_path('uploads/admin/documents/'), $fileName);

            if ($Document->image != 'photo.jpg' && is_file(public_path('uploads/admin/documents/' . $Document->image))) {
                unlink(public_path('uploads/admin/documents/' . $Document->image));
            }
            $Document->image = $fileName;
            $Document->save();
        }          

    return redirect()->route('admin.documents.show')->with('success', 'Document Update Successfully .');
    }



   

     public function destroy($id) {
        $d = Document::find($id); 
        $d->delete(); 
        return redirect()->route('admin.documents.show')->with('success', 'Document Delete Successfully.');
    }

    
    
    

}

