<?php

namespace App\Helpers\Route;


use Illuminate\Support\Facades\Route;
use Illuminate\Http\Request;

class CustomerRouteHelper
{
    public static function routes()
    {
        Route::group(['middleware' => 'auth:customer'], function () {
           

      Route::group(['prefix' => 'customer'], function () {
          
      Route::get('/dashboard', array('as' => 'customer.dashboard.show', 'uses' => 'Customer\CustomerController@dashboard'));         

      Route::get('/profile', array('as' => 'customer.profile.showprofile', 'uses' => 'Customer\CustomerController@showprofile'));
          
      Route::any('/profile/update/{id}', array('as' => 'customer.profile.update', 'uses' => 'Customer\CustomerController@profileUpdate'));

  });
            
            

           
        });
    }
}