<?php

namespace App\Helpers\Route;


use Illuminate\Support\Facades\Route;


class AuditRouteHelper
{
    public static function routes() {
        

    

    Route::group(['prefix' => 'audit'], function () {           
    
    Route::group(['prefix' => 'leads'], function () {
    Route::any('', array('as' => 'audit.leads.show', 'uses' => 'Admin\Audit\LeadController@index'));
    Route::get('create', array('as' => 'audit.leads.create', 'uses' => 'Admin\Audit\LeadController@create'));
    Route::post('store', array('as' => 'audit.leads.store', 'uses' => 'Admin\Audit\LeadController@store'));
    Route::get('edit/{id}', array('as' => 'audit.leads.edit', 'uses' => 'Admin\Audit\LeadController@show'));
    Route::post('update/{id}', array('as' => 'audit.leads.update', 'uses' => 'Admin\Audit\LeadController@update'));
    Route::get('delete/{id}', array('as' => 'audit.leads.delete', 'uses' => 'Admin\Audit\LeadController@destroy'));
    Route::get('importExportView', array('as' => 'audit.leads.import', 'uses' => 'Admin\Audit\LeadController@importExportView'));
    Route::post('import', array('as' => 'audit.leads.import.store', 'uses' => 'Admin\Audit\LeadController@import'));


    Route::any('sales', array('as' => 'audit.sales.show', 'uses' => 'Admin\Audit\SaleController@index'));
    Route::any('crm/sales', array('as' => 'audit.crm.sales.show', 'uses' => 'Admin\Audit\SaleController@crmsales'));

    Route::post('/sales/store', array('as' => 'audit.sales.store', 'uses' => 'Admin\Audit\SaleController@store'));
    Route::get('/sales/create/{id}', array('as' => 'audit.sales.create', 'uses' => 'Admin\Audit\SaleController@create'));
    Route::any('detail/{id}', array('as' => 'audit.sales.detail', 'uses' => 'Admin\Audit\SaleController@details'));

    
    Route::get('/details/{id}', array('as' => 'audit.assigned.leads.details', 'uses' => 'Admin\Audit\LeadController@details'));
    Route::post('/call/store', array('as' => 'audit.leads.call.store', 'uses' => 'Admin\Audit\ActivityController@store'));
    Route::post('/call/convert', array('as' => 'audit.leads.call.convert', 'uses' => 'Admin\Audit\ActivityController@convert'));   

    });

   Route::group(['prefix' => 'opportunity'], function () {
   Route::any('/', array('as' => 'audit.opportunity.show', 'uses' => 'Admin\Audit\OpportunityController@index'));
   Route::get('edit/{id}', array('as' => 'audit.opportunity.edit', 'uses' => 'Admin\Audit\OpportunityController@show'));
   Route::post('update/{id}', array('as' => 'audit.opportunity.update', 'uses' => 'Admin\Audit\OpportunityController@update'));

     

      });

   Route::group(['prefix' => 'audit/call/activity/Leads'], function () {
    Route::any('', array('as' => 'audit.reports.activity.show', 'uses' => 'Admin\Audit\ActivityController@index'));
    Route::get('create', array('as' => 'audit.reports.activity.create', 'uses' => 'Admin\Audit\ActivityController@create'));
    Route::post('store', array('as' => 'audit.reports.activity.store', 'uses' => 'Admin\Audit\ActivityController@store'));
    Route::get('edit/{id}', array('as' => 'audit.reports.activity.edit', 'uses' => 'Admin\Audit\ActivityController@show'));
    Route::post('update/{id}', array('as' => 'audit.reports.activity.update', 'uses' => 'Admin\Audit\ActivityController@update'));
    Route::get('delete/{id}', array('as' => 'audit.reports.activity.delete', 'uses' => 'Admin\Audit\ActivityController@destroy'));
});
   

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
      Route::group(['prefix' => 'business-info/accounts'], function () {
   Route::any('', array('as' => 'audit.business.account.show', 'uses' => 'Admin\Audit\Business\AccountController@index'));

});

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   Route::group(['prefix' => 'business-info/contact'], function () {
    Route::any('', array('as' => 'audit.business.contact.show', 'uses' => 'Admin\Audit\Business\ContactController@index'));

     });


 Route::group(['prefix' => 'renewals'], function () {

        Route::any('/', array('as' => 'audit.renewal.show', 'uses' => 'Admin\Audit\PolicyController@renewals'));

        });


     });           
     
    
    
    }
  }