<?php

namespace App\Helpers\Route;


use Illuminate\Support\Facades\Route;
use Illuminate\Http\Request;

class AgentRouteHelper
{
    public static function routes()
    {
        Route::group(['middleware' => 'auth:agent'], function () {
           

      Route::group(['prefix' => 'agent'], function () {
          
      Route::get('/dashboard', array('as' => 'agent.dashboard.show', 'uses' => 'Agent\AgentController@dashboard'));         

      Route::get('/profile', array('as' => 'agent.profile.showprofile', 'uses' => 'Agent\AgentController@showprofile'));
          
      Route::any('/profile/update/{id}', array('as' => 'agent.profile.update', 'uses' => 'Agent\AgentController@profileUpdate'));


 /////////////////////////////////////////////////////////////////////////////////////////////////////
   Route::group(['prefix' => 'customers'], function () {  
  Route::get('/', array('as' => 'agent.customer.show', 'uses' => 'Agent\CustomerController@index'));
  Route::get('/create', array('as' => 'agent.customer.create', 'uses' => 'Agent\CustomerController@create'));
  Route::post('/store', array('as' => 'agent.customer.store', 'uses' => 'Agent\CustomerController@store'));
  Route::get('/edit/{id}', array('as' => 'agent.customer.edit', 'uses' => 'Agent\CustomerController@show'));

   Route::get('/details/{id}', array('as' => 'agent.customer.details', 'uses' => 'Agent\CustomerController@details'));

  Route::post('/update/{id}', array('as' => 'agent.customer.update', 'uses' => 'Agent\CustomerController@update'));

  Route::get('/delete/{id}', array('as' => 'agent.customer.delete', 'uses' => 'Agent\CustomerController@destroy'));
    });

 Route::group(['prefix' => 'service'], function () {  
  Route::get('/', array('as' => 'agent.service.show', 'uses' => 'Agent\ServiceController@index'));
  Route::get('/create', array('as' => 'agent.service.create', 'uses' => 'Agent\ServiceController@create'));
  Route::post('/store', array('as' => 'agent.service.store', 'uses' => 'Agent\ServiceController@store'));
  Route::get('/edit/{id}', array('as' => 'agent.service.edit', 'uses' => 'Agent\ServiceController@show'));

  Route::post('/update/{id}', array('as' => 'agent.service.update', 'uses' => 'Agent\ServiceController@update'));

  Route::get('/delete/{id}', array('as' => 'agent.service.delete', 'uses' => 'Agent\ServiceController@destroy'));
    });

 Route::group(['prefix' => 'activity_log'], function () {  
  Route::any('/', array('as' => 'agent.activity.show', 'uses' => 'Agent\ActivityController@index'));
  Route::get('/create', array('as' => 'agent.activity.create', 'uses' => 'Agent\ActivityController@create'));
  Route::post('/store', array('as' => 'agent.activity.store', 'uses' => 'Agent\ActivityController@store'));
  Route::get('/edit/{id}', array('as' => 'agent.activity.edit', 'uses' => 'Agent\ActivityController@show'));

  Route::post('/update/{id}', array('as' => 'agent.activity.update', 'uses' => 'Agent\ActivityController@update'));

  Route::get('/delete/{id}', array('as' => 'agent.activity.delete', 'uses' => 'Agent\ActivityController@destroy'));
    });


 /////////////////////////////////////////////////////////////////////////////////////////////////////

  });
            
            

           
        });
    }
}