<?php

namespace App\Helpers\Route;


use Illuminate\Support\Facades\Route;


class AdminRouteHelper
{
    public static function routes() {
        

    Route::group(['middleware' => ['auth','notifier']], function () {

    Route::group(['prefix' => 'admin'], function () {
    Route::get('/dashboard', 'Admin\AdminController@index')->name('adminDashboard');
    Route::get('/profile', array('as' => 'admin.profile.showprofile', 'uses' => 'Admin\AdminController@showprofile'));
    Route::any('/profile/update/{id}', array('as' => 'admin.profile.update', 'uses' => 'Admin\AdminController@profileUpdate'));
    
  
     Route::any('/export/reports/opportunities', array('as' => 'admin.opportunities.exportCsv', 'uses' => 'Admin\Reports\OpportunityController@exportCsv'));

     
    
    Route::post('/search/results', array('as' => 'admin.search.show', 'uses' => 'Admin\AdminController@searchShow'));
    // /Route::post('/search/results', array('as' => 'admin.search', 'uses' => 'Admin\AdminController@search'));

    Route::get('/sendemail', array('as' => 'admin.email.show', 'uses' => 'Admin\sendEmailController@index'));
    Route::post('/sendemail/send', array('as' => 'admin.email.send', 'uses' => 'Admin\sendEmailController@send'));

    Route::get('/sendemail/customer', array('as' => 'admin.customer.infoEmail.show', 'uses' => 'Admin\sendEmailController@updatedInfoEmailToCustomer'));

    Route::post('/sendemail/customer/send', array('as' => 'admin.customer.infoEmail.send', 'uses' => 'Admin\sendEmailController@sendInfoEmail'));

    
    Route::get('/mail', array('as' => 'admin.mail.show', 'uses' => 'Admin\SendEmailController@sendEmail'));
    Route::post('/mail/send', array('as' => 'admin.mail.send', 'uses' => 'Admin\SendEmailController@sendTestEmail'));


    Route::group(['prefix' => 'call/activities'], function () {
    Route::any('/', array('as' => 'admin.reports.callactivity.show', 'uses' => 'Admin\Reports\CallActivityController@index'));
    Route::get('create', array('as' => 'admin.reports.callactivity.create', 'uses' => 'Admin\Reports\CallActivityController@create'));
    Route::post('store', array('as' => 'admin.reports.callactivity.store', 'uses' => 'Admin\Reports\CallActivityController@store'));
    Route::get('edit/{id}', array('as' => 'admin.reports.callactivity.edit', 'uses' => 'Admin\Reports\CallActivityController@show'));
    Route::post('update/{id}', array('as' => 'admin.reports.callactivity.update', 'uses' => 'Admin\Reports\CallActivityController@update'));
    Route::get('delete/{id}', array('as' => 'admin.reports.callactivity.delete', 'uses' => 'Admin\Reports\CallActivityController@destroy'));

    Route::get('report/export/', array('as' => 'admin.reports.callactivity.export', 'uses' => 'Admin\Reports\CallActivityController@exportCSV'));
});

    Route::group(['prefix' => 'email/campaigning'], function () {
    Route::any('', array('as' => 'admin.email.campaign.show', 'uses' => 'Admin\EmailCampaigningController@index'));
    Route::get('create', array('as' => 'admin.email.campaign.create', 'uses' => 'Admin\EmailCampaigningController@create'));
    Route::post('store', array('as' => 'admin.email.campaign.store', 'uses' => 'Admin\EmailCampaigningController@store'));
    Route::get('edit/{id}', array('as' => 'admin.email.campaign.edit', 'uses' => 'Admin\EmailCampaigningController@show'));
    Route::post('update/{id}', array('as' => 'admin.email.campaign.update', 'uses' => 'Admin\EmailCampaigningController@update'));
    Route::get('delete/{id}', array('as' => 'admin.email.campaign.delete', 'uses' => 'Admin\EmailCampaigningController@destroy'));

 });
    \App\Helpers\Route\ManagementRouteHelper::routes();
    \App\Helpers\Route\AuditRouteHelper::routes();

    Route::group(['prefix' => 'agents'], function () {
    Route::any('', array('as' => 'admin.agents.show', 'uses' => 'Admin\AgentController@index'));
    Route::get('create', array('as' => 'admin.agents.create', 'uses' => 'Admin\AgentController@create'));
    Route::post('store', array('as' => 'admin.agents.store', 'uses' => 'Admin\AgentController@store'));
    Route::get('edit/{id}', array('as' => 'admin.agents.edit', 'uses' => 'Admin\AgentController@show'));
    Route::post('update/{id}', array('as' => 'admin.agents.update', 'uses' => 'Admin\AgentController@update'));
    Route::get('delete/{id}', array('as' => 'admin.agents.delete', 'uses' => 'Admin\AgentController@destroy'));

 });


    Route::group(['prefix' => 'customers'], function () {
    Route::any('', array('as' => 'admin.customer.show', 'uses' => 'Admin\Reports\CustomerController@index'));
    Route::get('create', array('as' => 'admin.customer.create', 'uses' => 'Admin\Reports\CustomerController@create'));
    Route::post('store', array('as' => 'admin.customer.store', 'uses' => 'Admin\Reports\CustomerController@store'));
    Route::get('edit/{id}', array('as' => 'admin.customer.edit', 'uses' => 'Admin\Reports\CustomerController@show'));
    Route::post('update/{id}', array('as' => 'admin.customer.update', 'uses' => 'Admin\Reports\CustomerController@update'));
    Route::get('view/{id}', array('as' => 'admin.customer.view', 'uses' => 'Admin\Reports\CustomerController@details'));
    Route::get('delete/{id}', array('as' => 'admin.customer.delete', 'uses' => 'Admin\Reports\CustomerController@destroy'));
    Route::get('activate', array('as' => 'admin.customer.activate', 'uses' => 'Admin\Reports\CustomerController@activate'));
    Route::get('deactivate', array('as' => 'admin.customer.deactivate', 'uses' => 'Admin\CustomerController@deactivate'));

   });

    Route::group(['prefix' => 'staffs'], function () {
    Route::any('', array('as' => 'admin.staff.show', 'uses' => 'Admin\StaffController@index'));
    Route::get('create', array('as' => 'admin.staff.create', 'uses' => 'Admin\StaffController@create'));
    Route::post('store', array('as' => 'admin.staff.store', 'uses' => 'Admin\StaffController@store'));
    Route::get('edit/{id}', array('as' => 'admin.staff.edit', 'uses' => 'Admin\StaffController@show'));
    Route::post('update/{id}', array('as' => 'admin.staff.update', 'uses' => 'Admin\StaffController@update'));
    Route::get('delete/{id}', array('as' => 'admin.staff.delete', 'uses' => 'Admin\StaffController@destroy'));


 });

     Route::group(['prefix' => 'insurance'], function () {
    Route::any('', array('as' => 'admin.insurance.show', 'uses' => 'Admin\InsuranceController@index'));
    Route::get('create', array('as' => 'admin.insurance.create', 'uses' => 'Admin\InsuranceController@create'));
    Route::post('store', array('as' => 'admin.insurance.store', 'uses' => 'Admin\InsuranceController@store'));
    Route::get('edit/{id}', array('as' => 'admin.insurance.edit', 'uses' => 'Admin\InsuranceController@show'));
    Route::post('update/{id}', array('as' => 'admin.insurance.update', 'uses' => 'Admin\InsuranceController@update'));
    Route::get('delete/{id}', array('as' => 'admin.insurance.delete', 'uses' => 'Admin\InsuranceController@destroy'));

   
    
 });

    Route::group(['prefix' => 'agencies'], function () {
    Route::any('', array('as' => 'admin.agencies.show', 'uses' => 'Admin\AgencyController@index'));
    Route::get('create', array('as' => 'admin.agencies.create', 'uses' => 'Admin\AgencyController@create'));
    Route::post('store', array('as' => 'admin.agencies.store', 'uses' => 'Admin\AgencyController@store'));
    Route::get('edit/{id}', array('as' => 'admin.agencies.edit', 'uses' => 'Admin\AgencyController@show'));
    Route::post('update/{id}', array('as' => 'admin.agencies.update', 'uses' => 'Admin\AgencyController@update'));
    Route::get('delete/{id}', array('as' => 'admin.agencies.delete', 'uses' => 'Admin\AgencyController@destroy'));

   
    
 });

    Route::group(['prefix' => 'users'], function () {
    Route::any('', array('as' => 'admin.users.show', 'uses' => 'Admin\UserController@index'));
    Route::get('create', array('as' => 'admin.users.create', 'uses' => 'Admin\UserController@create'));
    Route::post('store', array('as' => 'admin.users.store', 'uses' => 'Admin\UserController@store'));
    Route::get('edit/{id}', array('as' => 'admin.users.edit', 'uses' => 'Admin\UserController@show'));
    Route::post('update/{id}', array('as' => 'admin.users.update', 'uses' => 'Admin\UserController@update'));
    Route::get('delete/{id}', array('as' => 'admin.users.delete', 'uses' => 'Admin\UserController@destroy'));

    Route::get('assign/{id}', array('as' => 'admin.users.list.show', 'uses' => 'Admin\UserController@userList'));
    Route::post('assign/save/{id}', array('as' => 'admin.users.list.store', 'uses' => 'Admin\UserController@assignToUser'));
    Route::get('/assign/user/delete/{id}', array('as' => 'admin.assign.users.delete', 'uses' => 'Admin\UserController@assignedUserDelete'));

    Route::post('password/verify', array('as' => 'admin.users.password.verify', 'uses' => 'Admin\UserController@passwordValidation'));

    Route::get('/export', array('as' => 'admin.users.exportCsv', 'uses' => 'Admin\UserController@exportCsv'));
    
 });

    Route::group(['prefix' => 'reports'], function () {
    Route::any('renewal', array('as' => 'admin.reports.renewal.show', 'uses' => 'Admin\Reports\PolicyController@renewals'));
    Route::get('renewal/details/{id}', array('as' => 'admin.reports.renewal.details', 'uses' => 'Admin\Reports\PolicyController@details'));
    Route::any('sales', array('as' => 'admin.reports.sales.show', 'uses' => 'Admin\Reports\SaleController@index'));
    Route::any('crm/sales', array('as' => 'admin.reports.crm.sales.show', 'uses' => 'Admin\Reports\SaleController@crmsales'));
    Route::get('sales/crm/export', array('as' => 'admin.reports.crm.sales.exportCsv', 'uses' => 'Admin\Reports\SaleController@exportCsv1'));
    Route::get('sales/export', array('as' => 'admin.reports.sales.exportCsv', 'uses' => 'Admin\Reports\SaleController@exportCsv'));

   Route::get('sales/details/{id}', array('as' => 'admin.reports.sales.details', 'uses' => 'Admin\Reports\SaleController@details'));

    Route::get('renewal/export', array('as' => 'admin.reports.renewal.export', 'uses' => 'Admin\Reports\PolicyController@export'));

   });


   
  Route::group(['prefix' => 'leads'], function () {
       Route::any('', array('as' => 'admin.leads.show', 'uses' => 'Admin\Reports\LeadController@index'));
       Route::get('/export', array('as' => 'admin.reports.leads.exportCsv', 'uses' => 'Admin\Reports\LeadController@exportCsv'));

 });

Route::group(['prefix' => 'call/activity/Leads'], function () {
Route::any('', array('as' => 'admin.reports.activity.show', 'uses' => 'Admin\Reports\ActivityController@index'));
Route::get('create', array('as' => 'admin.reports.activity.create', 'uses' => 'Admin\Reports\ActivityController@create'));
Route::post('store', array('as' => 'admin.reports.activity.store', 'uses' => 'Admin\Reports\ActivityController@store'));
Route::get('edit/{id}', array('as' => 'admin.reports.activity.edit', 'uses' => 'Admin\Reports\ActivityController@show'));
Route::post('update/{id}', array('as' => 'admin.reports.activity.update', 'uses' => 'Admin\Reports\ActivityController@update'));
Route::get('delete/{id}', array('as' => 'admin.reports.activity.delete', 'uses' => 'Admin\Reports\ActivityController@destroy'));
Route::get('export', array('as' => 'admin.reports.activity.export', 'uses' => 'Admin\Reports\ActivityController@export'));
});

Route::group(['prefix' => 'call/activity/Customers'], function () {
Route::get('', array('as' => 'admin.reports.customer.activity.show', 'uses' => 'Admin\Reports\CustomerActivityController@index'));
Route::get('create', array('as' => 'admin.reports.customer.activity.create', 'uses' => 'Admin\Reports\CustomerActivityController@create'));
Route::post('store', array('as' => 'admin.reports.customer.activity.store', 'uses' => 'Admin\Reports\CustomerActivityController@store'));
Route::get('edit/{id}', array('as' => 'admin.reports.customer.activity.edit', 'uses' => 'Admin\Reports\CustomerActivityController@show'));
Route::post('update/{id}', array('as' => 'admin.reports.customer.activity.update', 'uses' => 'Admin\Reports\CustomerActivityController@update'));
Route::get('delete/{id}', array('as' => 'admin.reports.customer.activity.delete', 'uses' => 'Admin\Reports\CustomerActivityController@destroy'));
});

Route::group(['prefix' => 'call/activity/contacts'], function () {
Route::get('', array('as' => 'admin.reports.contacts.activity.show', 'uses' => 'Admin\Reports\ContactActivityController@index'));
Route::get('create', array('as' => 'admin.reports.contacts.activity.create', 'uses' => 'Admin\Reports\ContactActivityController@create'));
Route::post('store', array('as' => 'admin.reports.contacts.activity.store', 'uses' => 'Admin\Reports\ContactActivityController@store'));
Route::get('edit/{id}', array('as' => 'admin.reports.contacts.activity.edit', 'uses' => 'Admin\Reports\ContactActivityController@show'));
Route::post('update/{id}', array('as' => 'admin.reports.contacts.activity.update', 'uses' => 'Admin\Reports\ContactActivityController@update'));
Route::get('delete/{id}', array('as' => 'admin.reports.contacts.activity.delete', 'uses' => 'Admin\Reports\ContactActivityController@destroy'));
});



Route::group(['prefix' => 'call/activity/Prospects'], function () {
Route::get('', array('as' => 'admin.reports.prospect.activity.show', 'uses' => 'Admin\Reports\ProspectActivityController@index'));
Route::get('create', array('as' => 'admin.reports.prospect.activity.create', 'uses' => 'Admin\Reports\ProspectActivityController@create'));
Route::post('store', array('as' => 'admin.reports.prospect.activity.store', 'uses' => 'Admin\Reports\ProspectActivityController@store'));
Route::get('edit/{id}', array('as' => 'admin.reports.prospect.activity.edit', 'uses' => 'Admin\Reports\ProspectActivityController@show'));
Route::post('update/{id}', array('as' => 'admin.reports.prospect.activity.update', 'uses' => 'Admin\Reports\ProspectActivityController@update'));
Route::get('delete/{id}', array('as' => 'admin.reports.prospect.activity.delete', 'uses' => 'Admin\Reports\ProspectActivityController@destroy'));
});



Route::group(['prefix' => 'reports/opportunity'], function () {
Route::any('/', array('as' => 'admin.reports.opportunity.show', 'uses' => 'Admin\Reports\OpportunityController@index'));
Route::get('create', array('as' => 'admin.reports.opportunity.create', 'uses' => 'Admin\Reports\OpportunityController@create'));

Route::post('store', array('as' => 'admin.reports.opportunity.store', 'uses' => 'Admin\Reports\OpportunityController@store'));

Route::get('edit/{id}', array('as' => 'admin.reports.opportunity.edit', 'uses' => 'Admin\Reports\OpportunityController@show'));

Route::post('update/{id}', array('as' => 'admin.reports.opportunity.update', 'uses' => 'Admin\Reports\OpportunityController@update'));

Route::get('delete/{id}', array('as' => 'admin.reports.opportunity.delete', 'uses' => 'Admin\Reports\OpportunityController@destroy'));
});


Route::group(['prefix' => 'business-info/accounts'], function () {
Route::any('', array('as' => 'admin.business.account.show', 'uses' => 'Admin\Business\BusinessController@index'));
Route::get('create', array('as' => 'admin.business.account.create', 'uses' => 'Admin\Business\BusinessController@create'));
Route::post('store', array('as' => 'admin.business.account.store', 'uses' => 'Admin\Business\BusinessController@store'));
Route::get('edit/{id}', array('as' => 'admin.business.account.edit', 'uses' => 'Admin\Business\BusinessController@show'));

Route::post('update/{id}', array('as' => 'admin.business.account.update', 'uses' => 'Admin\Business\BusinessController@update'));

Route::get('delete/{id}', array('as' => 'admin.business.account.delete', 'uses' => 'Admin\Business\BusinessController@destroy'));

Route::post('assign/{id}', array('as' => 'admin.business.account.assign', 'uses' => 'Admin\Business\BusinessController@accountAssignToContact'));

Route::get('export/', array('as' => 'admin.business.account.export', 'uses' => 'Admin\Business\BusinessController@export'));

});


Route::group(['prefix' => 'business-info/contact'], function () {
Route::any('', array('as' => 'admin.business.contact.show', 'uses' => 'Admin\Business\ContactController@index'));
Route::get('create', array('as' => 'admin.business.contact.create', 'uses' => 'Admin\Business\ContactController@create'));
Route::post('store', array('as' => 'admin.business.contact.store', 'uses' => 'Admin\Business\ContactController@store'));
Route::get('edit/{id}', array('as' => 'admin.business.contact.edit', 'uses' => 'Admin\Business\ContactController@show'));
Route::post('update/{id}', array('as' => 'admin.business.contact.update', 'uses' => 'Admin\Business\ContactController@update'));
Route::get('delete/{id}', array('as' => 'admin.business.contact.delete', 'uses' => 'Admin\Business\ContactController@destroy'));
Route::get('export/', array('as' => 'admin.business.contact.export', 'uses' => 'Admin\Business\ContactController@export'));

});

Route::group(['prefix' => 'business-info/businessLeads'], function () {
Route::any('', array('as' => 'admin.business.leads.show', 'uses' => 'Admin\Business\LeadController@index'));
Route::get('create', array('as' => 'admin.business.leads.create', 'uses' => 'Admin\Business\LeadController@create'));
Route::post('store', array('as' => 'admin.business.leads.store', 'uses' => 'Admin\Business\LeadController@store'));
Route::get('edit/{id}', array('as' => 'admin.business.leads.edit', 'uses' => 'Admin\Business\LeadController@show'));
Route::post('update/{id}', array('as' => 'admin.business.leads.update', 'uses' => 'Admin\Business\LeadController@update'));
Route::get('delete/{id}', array('as' => 'admin.business.leads.delete', 'uses' => 'Admin\Business\LeadController@destroy'));

});

Route::group(['prefix' => 'tasks'], function () {
Route::any('', array('as' => 'admin.tasks.show', 'uses' => 'Admin\Tasks\TaskController@index'));
Route::get('create', array('as' => 'admin.tasks.create', 'uses' => 'Admin\Tasks\TaskController@create'));
Route::post('store', array('as' => 'admin.tasks.store', 'uses' => 'Admin\Tasks\TaskController@store'));
Route::get('edit/{id}', array('as' => 'admin.tasks.edit', 'uses' => 'Admin\Tasks\TaskController@show'));
Route::post('update/{id}', array('as' => 'admin.tasks.update', 'uses' => 'Admin\Tasks\TaskController@update'));
Route::get('delete/{id}', array('as' => 'admin.tasks.delete', 'uses' => 'Admin\Tasks\TaskController@destroy'));
Route::post('ajax/', array('as' => 'admin.tasks.ajax', 'uses' => 'Admin\Tasks\TaskController@getAjaxResult'));
Route::any('/report/export', array('as' => 'admin.tasks.exportCsv', 'uses' => 'Admin\Tasks\TaskController@exportTasks'));
 

});

Route::group(['prefix' => 'call/activity/documents'], function () {
Route::any('', array('as' => 'admin.documents.show', 'uses' => 'Admin\Reports\DocumentController@index'));
Route::get('create', array('as' => 'admin.documents.create', 'uses' => 'Admin\Reports\DocumentController@create'));
Route::post('store', array('as' => 'admin.documents.store', 'uses' => 'Admin\Reports\DocumentController@store'));
Route::get('edit/{id}', array('as' => 'admin.documents.edit', 'uses' => 'Admin\Reports\DocumentController@show'));
Route::post('update/{id}', array('as' => 'admin.documents.update', 'uses' => 'Admin\Reports\DocumentController@update'));
Route::get('delete/{id}', array('as' => 'admin.documents.delete', 'uses' => 'Admin\Reports\DocumentController@destroy'));

});

///////////////////////////////// Supervisor Route Prefix /////////////////////////////////



    Route::group(['prefix' => 'supervisiors/leads'], function () {
    Route::any('', array('as' => 'supervisiors.leads.show', 'uses' => 'Admin\Supervisiors\LeadController@index'));
    Route::get('create', array('as' => 'supervisiors.leads.create', 'uses' => 'Admin\Supervisiors\LeadController@create'));
    Route::post('store', array('as' => 'supervisiors.leads.store', 'uses' => 'Admin\Supervisiors\LeadController@store'));
    Route::get('edit/{id}', array('as' => 'supervisiors.leads.edit', 'uses' => 'Admin\Supervisiors\LeadController@show'));
    Route::post('update/{id}', array('as' => 'supervisiors.leads.update', 'uses' => 'Admin\Supervisiors\LeadController@update'));
    Route::get('delete/{id}', array('as' => 'supervisiors.leads.delete', 'uses' => 'Admin\Supervisiors\LeadController@destroy'));
    Route::get('importExportView', array('as' => 'supervisiors.leads.import', 'uses' => 'Admin\Supervisiors\LeadController@importExportView'));
    Route::post('import', array('as' => 'supervisiors.leads.import.store', 'uses' => 'Admin\Supervisiors\LeadController@import'));

  Route::get('export', array('as' => 'supervisiors.leads.exportCsv', 'uses' => 'Admin\Supervisiors\LeadController@exportCsv'));


    Route::any('sales', array('as' => 'supervisiors.sales.show', 'uses' => 'Admin\Supervisiors\SaleController@index'));
    Route::any('crm/sales', array('as' => 'supervisiors.crm.sales.show', 'uses' => 'Admin\Supervisiors\SaleController@crmsales'));

    Route::any('detail/{id}', array('as' => 'supervisiors.sales.detail', 'uses' => 'Admin\Supervisiors\SaleController@details'));

    Route::get('sales/export', array('as' => 'supervisiors.sales.exportCsv', 'uses' => 'Admin\Supervisiors\SaleController@exportCsv'));
    Route::get('crm/sales/export', array('as' => 'supervisiors.crm.sales.exportCsv', 'uses' => 'Admin\Supervisiors\SaleController@exportCsv1'));

    });

    Route::group(['prefix' => 'supervisiors/opportunity'], function () {
     Route::any('/', array('as' => 'supervisiors.opportunity.show', 'uses' => 'Admin\Supervisiors\OpportunityController@index'));
     Route::get('create', array('as' => 'supervisiors.opportunity.create', 'uses' => 'Admin\Reports\OpportunityController@create'));

     Route::post('store', array('as' => 'supervisiors.opportunity.store', 'uses' => 'Admin\Supervisiors\OpportunityController@store'));

    Route::get('edit/{id}', array('as' => 'supervisiors.opportunity.edit', 'uses' => 'Admin\Supervisiors\OpportunityController@show'));

     Route::post('update/{id}', array('as' => 'supervisiors.opportunity.update', 'uses' => 'Admin\Supervisiors\OpportunityController@update'));

     Route::get('delete/{id}', array('as' => 'supervisiors.opportunity.delete', 'uses' => 'Admin\Supervisiors\OpportunityController@destroy'));

      Route::get('export', array('as' => 'supervisiors.opportunity.exportCsv', 'uses' => 'Admin\Supervisiors\OpportunityController@exportCsv'));
});

    Route::group(['prefix' => 'supervisiors/leads'], function () {
    Route::any('sales', array('as' => 'supervisiors.sales.show', 'uses' => 'Admin\Supervisiors\SaleController@index'));
    Route::get('sbusales/{id}', array('as' => 'supervisiors.sales.sbu', 'uses' => 'Admin\Supervisiors\SaleController@getSbuPolicies'));
    Route::get('sales/create/{id}', array('as' => 'supervisiors.sales.create', 'uses' => 'Admin\Supervisiors\SaleController@create'));
    Route::post('sales/store', array('as' => 'supervisiors.sales.store', 'uses' => 'Admin\Supervisiors\SaleController@store'));
    Route::any('detail/{id}', array('as' => 'supervisiors.sales.detail', 'uses' => 'Admin\Supervisiors\SaleController@details'));

});

    Route::group(['prefix' => 'supervisiors/accounts'], function () {
    Route::any('/', array('as' => 'supervisiors.accounts.show', 'uses' => 'Admin\Supervisiors\AccountController@index'));

    Route::get('export', array('as' => 'supervisiors.accounts.exportCsv', 'uses' => 'Admin\Supervisiors\AccountController@exportCsv'));
    
});

    Route::group(['prefix' => 'supervisiors/contacts'], function () {
    Route::any('', array('as' => 'supervisiors.contact.show', 'uses' => 'Admin\Supervisiors\ContactController@index'));
    Route::get('create', array('as' => 'supervisiors.contact.create', 'uses' => 'Admin\Supervisiors\ContactController@create'));
    Route::post('store', array('as' => 'supervisiors.contact.store', 'uses' => 'Admin\Supervisiors\ContactController@store'));
    Route::get('edit/{id}', array('as' => 'supervisiors.contact.edit', 'uses' => 'Admin\Supervisiors\ContactController@show'));
    Route::post('update/{id}', array('as' => 'supervisiors.contact.update', 'uses' => 'Admin\Supervisiors\ContactController@update'));
    Route::get('delete/{id}', array('as' => 'supervisiors.contact.delete', 'uses' => 'Admin\Supervisiors\ContactController@destroy'));

    Route::get('export', array('as' => 'supervisiors.contact.exportCsv', 'uses' => 'Admin\Supervisiors\ContactController@exportCsv'));
    
});
    
    Route::group(['prefix' => 'supervisiors/tasks'], function () {
    Route::any('', array('as' => 'supervisiors.tasks.show', 'uses' => 'Admin\Supervisiors\Task\TaskController@index'));
    Route::get('create', array('as' => 'supervisiors.tasks.create', 'uses' => 'Admin\Supervisiors\Task\TaskController@create'));
    Route::post('store', array('as' => 'supervisiors.tasks.store', 'uses' => 'Admin\Supervisiors\Task\TaskController@store'));
    Route::get('edit/{id}', array('as' => 'supervisiors.tasks.edit', 'uses' => 'Admin\Supervisiors\Task\TaskController@show'));
    Route::post('update/{id}', array('as' => 'supervisiors.tasks.update', 'uses' => 'Admin\Supervisiors\Task\TaskController@update'));
    Route::get('delete/{id}', array('as' => 'supervisiors.tasks.delete', 'uses' => 'Admin\Supervisiors\Task\TaskController@destroy'));

    Route::get('notes/{id}', array('as' => 'supervisiors.tasks.notes.show', 'uses' => 'Admin\Supervisiors\Task\TaskController@ShowNotesdetails'));

    Route::get('/export', array('as' => 'supervisiors.tasks.exportCsv', 'uses' => 'Admin\Supervisiors\Task\TaskController@exportCsv'));

});

    Route::group(['prefix' => 'supervisiors/activity'], function () {
        Route::any('', array('as' => 'supervisiors.callactivity.show', 'uses' => 'Admin\Supervisiors\CallActivityController@index'));
    Route::get('create', array('as' => 'supervisiors.callactivity.create', 'uses' => 'Admin\Supervisiors\CallActivityController@create'));
    Route::post('store', array('as' => 'supervisiors.callactivity.store', 'uses' => 'Admin\Supervisiors\CallActivityController@store'));
    Route::get('edit/{id}', array('as' => 'supervisiors.callactivity.edit', 'uses' => 'Admin\Supervisiors\CallActivityController@show'));
    Route::post('update/{id}', array('as' => 'supervisiors.callactivity.update', 'uses' => 'Admin\Supervisiors\CallActivityController@update'));
    Route::get('delete/{id}', array('as' => 'supervisiors.callactivity.delete', 'uses' => 'Admin\Supervisiors\CallActivityController@destroy'));

 Route::get('/export', array('as' => 'supervisiors.callactivity.exportCsv', 'uses' => 'Admin\Supervisiors\CallActivityController@exportCsv'));
        });

    Route::group(['prefix' => 'supervisiors/call/activity/Leads'], function () {
    Route::any('', array('as' => 'supervisiors.reports.activity.show', 'uses' => 'Admin\Supervisiors\ActivityController@index'));
    Route::get('create', array('as' => 'supervisiors.reports.activity.create', 'uses' => 'Admin\Supervisiors\ActivityController@create'));
    Route::post('store', array('as' => 'supervisiors.reports.activity.store', 'uses' => 'Admin\Supervisiors\ActivityController@store'));
    Route::get('edit/{id}', array('as' => 'supervisiors.reports.activity.edit', 'uses' => 'Admin\Supervisiors\ActivityController@show'));
    Route::post('update/{id}', array('as' => 'supervisiors.reports.activity.update', 'uses' => 'Admin\Supervisiors\ActivityController@update'));
    Route::get('delete/{id}', array('as' => 'supervisiors.reports.activity.delete', 'uses' => 'Admin\Supervisiors\ActivityController@destroy'));

     Route::get('export', array('as' => 'supervisiors.reports.activity.exportCsv', 'uses' => 'Admin\Supervisiors\ActivityController@exportCsv'));
});

   Route::group(['prefix' => 'supervisiors/myTasks'], function () {
    Route::any('/', array('as' => 'supervisiors.mytasks.show', 'uses' => 'Admin\Supervisiors\Task\TaskController@mytasks'));
    Route::get('/details/{id}', array('as' => 'supervisiors.mytasks.detail', 'uses' => 'Admin\Supervisiors\Task\TaskController@details'));

    Route::post('/details/update/{id}', array('as' => 'supervisiors.mytasks.detail.update', 'uses' => 'Admin\Supervisiors\Task\TaskController@detailUpdate'));

    Route::get('download/{id}', array('as' => 'supervisiors.mytasks.detail.download', 'uses' => 'Admin\Supervisiors\Task\TaskController@getDownload'));

    Route::get('/export', array('as' => 'supervisiors.mytasks.exportCsv', 'uses' => 'Admin\Supervisiors\Task\TaskController@myTasksexportCsv'));

     });

   Route::group(['prefix' => 'supervisiors/renewals'], function () {

        Route::any('/', array('as' => 'supervisiors.renewal.show', 'uses' => 'Admin\Supervisiors\PolicyController@renewals'));
        Route::get('export', array('as' => 'supervisiors.renewal.exportCsv', 'uses' => 'Admin\Supervisiors\PolicyController@exportCsv'));

        });
///////////////////////////////// Team Lead Route Prefix /////////////////////////////////



    Route::group(['prefix' => 'teamLead/leads'], function () {
    Route::any('', array('as' => 'teamLead.leads.show', 'uses' => 'Admin\TeamLead\LeadController@index'));
    Route::get('create', array('as' => 'teamLead.leads.create', 'uses' => 'Admin\TeamLead\LeadController@create'));
    Route::post('store', array('as' => 'teamLead.leads.store', 'uses' => 'Admin\TeamLead\LeadController@store'));
    Route::get('edit/{id}', array('as' => 'teamLead.leads.edit', 'uses' => 'Admin\TeamLead\LeadController@show'));
    Route::post('update/{id}', array('as' => 'teamLead.leads.update', 'uses' => 'Admin\TeamLead\LeadController@update'));
    Route::get('delete', array('as' => 'teamLead.leads.delete', 'uses' => 'Admin\TeamLead\LeadController@destroy'));
    Route::get('importExportView', array('as' => 'teamLead.leads.import', 'uses' => 'Admin\TeamLead\LeadController@importExportView'));
    Route::post('import', array('as' => 'teamLead.leads.import.store', 'uses' => 'Admin\TeamLead\LeadController@import'));

    Route::get('report/export', array('as' => 'teamLead.leads.exportCsv', 'uses' => 'Admin\TeamLead\LeadController@exportCsv'));

    Route::any('/sales', array('as' => 'teamLead.sales.show', 'uses' => 'Admin\TeamLead\SaleController@index'));
    Route::any('/crm/sales', array('as' => 'teamLead.crm.sales.show', 'uses' => 'Admin\TeamLead\SaleController@crmsales'));

    Route::post('/sales/store', array('as' => 'teamLead.sales.store', 'uses' => 'Admin\TeamLead\SaleController@store'));
    Route::get('/sales/create/{id}', array('as' => 'teamLead.sales.create', 'uses' => 'Admin\TeamLead\SaleController@create'));
    Route::get('/sales/export', array('as' => 'teamLead.sales.exportCsv', 'uses' => 'Admin\TeamLead\SaleController@exportCsv'));
    Route::get('/sales/crm/export', array('as' => 'teamLead.crm.sales.exportCsv', 'uses' => 'Admin\TeamLead\SaleController@exportCsv1'));

    Route::any('/detail/{id}', array('as' => 'teamLead.sales.detail', 'uses' => 'Admin\TeamLead\SaleController@details'));

   Route::any('/assigned', array('as' => 'teamLead.assigned.Leads', 'uses' => 'Admin\TeamLead\LeadController@assignedLeads'));
   Route::get('/details/{id}', array('as' => 'teamLead.assigned.leads.details', 'uses' => 'Admin\TeamLead\LeadController@details'));

   Route::post('/call/store', array('as' => 'teamLead.leads.call.store', 'uses' => 'Admin\TeamLead\ActivityController@store'));
   Route::post('/call/convert', array('as' => 'teamLead.leads.call.convert', 'uses' => 'Admin\TeamLead\ActivityController@convert'));

   Route::get('call/edit/{id}', array('as' => 'teamLead.leads.call.edit', 'uses' => 'Admin\TeamLead\ActivityController@show'));
   Route::get('delete/{id}', array('as' => 'teamLead.leads.call.delete', 'uses' => 'Admin\TeamLead\ActivityController@destroy'));

    Route::get('/calls', array('as' => 'teamLead.leads.call.show', 'uses' => 'Admin\TeamLead\ActivityController@index'));     
    Route::get('/calls/report/export', array('as' => 'teamLead.leads.call.exportCsv', 'uses' => 'Admin\TeamLead\ActivityController@exportCsv'));

 });

    Route::group(['prefix' => 'teamLead/opportunity'], function () {
     Route::any('/', array('as' => 'teamLead.opportunity.show', 'uses' => 'Admin\TeamLead\OpportunityController@index'));

     Route::get('create', array('as' => 'teamLead.opportunity.create', 'uses' => 'Admin\TeamLead\OpportunityController@create'));

     Route::post('store', array('as' => 'teamLead.opportunity.store', 'uses' => 'Admin\TeamLead\OpportunityController@store'));

    Route::get('edit/{id}', array('as' => 'teamLead.opportunity.edit', 'uses' => 'Admin\TeamLead\OpportunityController@show'));

     Route::post('update/{id}', array('as' => 'teamLead.opportunity.update', 'uses' => 'Admin\TeamLead\OpportunityController@update'));

     Route::get('delete/{id}', array('as' => 'teamLead.opportunity.delete', 'uses' => 'Admin\TeamLead\OpportunityController@destroy'));

      Route::get('export', array('as' => 'teamLead.opportunity.exportCsv', 'uses' => 'Admin\TeamLead\OpportunityController@exportCsv'));

      });

     Route::group(['prefix' => 'teamLead/call/activities'], function () {
    Route::any('', array('as' => 'teamLead.reports.callactivity.show', 'uses' => 'Admin\TeamLead\CallActivityController@index'));
    Route::get('create', array('as' => 'teamLead.reports.callactivity.create', 'uses' => 'Admin\TeamLead\CallActivityController@create'));
    Route::post('store', array('as' => 'teamLead.reports.callactivity.store', 'uses' => 'Admin\TeamLead\CallActivityController@store'));
    Route::get('edit/{id}', array('as' => 'teamLead.reports.callactivity.edit', 'uses' => 'Admin\TeamLead\CallActivityController@show'));
    Route::post('update/{id}', array('as' => 'teamLead.reports.callactivity.update', 'uses' => 'Admin\TeamLead\CallActivityController@update'));
    Route::get('delete/{id}', array('as' => 'teamLead.reports.callactivity.delete', 'uses' => 'Admin\TeamLead\CallActivityController@destroy'));

    Route::get('/report/export', array('as' => 'teamLead.reports.callactivity.exportCsv', 'uses' => 'Admin\TeamLead\CallActivityController@exportCsv'));


});



    Route::group(['prefix' => 'teamLead/tasks'], function () {
    Route::any('', array('as' => 'teamLead.tasks.show', 'uses' => 'Admin\TeamLead\TaskController@index'));
    Route::get('create', array('as' => 'teamLead.tasks.create', 'uses' => 'Admin\TeamLead\TaskController@create'));
    Route::post('store', array('as' => 'teamLead.tasks.store', 'uses' => 'Admin\TeamLead\TaskController@store'));
    Route::get('edit/{id}', array('as' => 'teamLead.tasks.edit', 'uses' => 'Admin\TeamLead\TaskController@show'));
    Route::post('update/{id}', array('as' => 'teamLead.tasks.update', 'uses' => 'Admin\TeamLead\TaskController@update'));
    Route::get('delete/{id}', array('as' => 'teamLead.tasks.delete', 'uses' => 'Admin\TeamLead\TaskController@destroy'));
    /*Wrong Route mentioned here*/
    Route::get('notes/{id}', array('as' => 'teamLead.tasks.notes.show', 'uses' => 'Admin\Staff\TaskController@ShowNotesdetails'));
    Route::get('/export', array('as' => 'teamLead.tasks.exportCsv', 'uses' => 'Admin\TeamLead\TaskController@exportCsv'));

    Route::any('myTasks', array('as' => 'teamLead.mytasks.show', 'uses' => 'Admin\TeamLead\TaskController@mytasks'));
    Route::get('tasks/details/{id}', array('as' => 'teamLead.mytasks.detail', 'uses' => 'Admin\TeamLead\TaskController@details'));

      Route::post('tasks/details/update/{id}', array('as' => 'teamLead.mytasks.detail.update', 'uses' => 'Admin\TeamLead\TaskController@detailUpdate'));

     Route::get('download/{id}', array('as' => 'teamLead.mytasks.detail.download', 'uses' => 'Admin\TeamLead\TaskController@getDownload'));

     Route::get('myTasks/export', array('as' => 'teamLead.mytasks.exportCsv', 'uses' => 'Admin\TeamLead\TaskController@myTasksexportCsv'));


  });

    Route::group(['prefix' => 'teamLead/business-info/accounts'], function () {
Route::any('', array('as' => 'teamLead.business.account.show', 'uses' => 'Admin\TeamLead\Business\AccountController@index'));
Route::get('create', array('as' => 'teamLead.business.account.create', 'uses' => 'Admin\TeamLead\Business\AccountController@create'));
Route::post('store', array('as' => 'teamLead.business.account.store', 'uses' => 'Admin\TeamLead\Business\AccountController@store'));
Route::get('edit/{id}', array('as' => 'teamLead.business.account.edit', 'uses' => 'Admin\TeamLead\Business\AccountController@show'));

Route::post('update/{id}', array('as' => 'teamLead.business.account.update', 'uses' => 'Admin\TeamLead\Business\AccountController@update'));

Route::get('delete/{id}', array('as' => 'teamLead.business.account.delete', 'uses' => 'Admin\TeamLead\Business\AccountController@destroy'));

Route::post('assign/{id}', array('as' => 'teamLead.business.account.assign', 'uses' => 'Admin\TeamLead\Business\AccountController@accountAssignToContact'));

Route::get('export/Accounts', array('as' => 'teamLead.business.account.exportCsv', 'uses' => 'Admin\TeamLead\Business\AccountController@exportCsv'));

});


Route::group(['prefix' => 'teamLead/business-info/contact'], function () {
Route::any('', array('as' => 'teamLead.business.contact.show', 'uses' => 'Admin\TeamLead\Business\ContactController@index'));
Route::get('create', array('as' => 'teamLead.business.contact.create', 'uses' => 'Admin\TeamLead\Business\ContactController@create'));
Route::post('store', array('as' => 'teamLead.business.contact.store', 'uses' => 'Admin\TeamLead\Business\ContactController@store'));
Route::get('edit/{id}', array('as' => 'teamLead.business.contact.edit', 'uses' => 'Admin\TeamLead\Business\ContactController@show'));
Route::post('update/{id}', array('as' => 'teamLead.business.contact.update', 'uses' => 'Admin\TeamLead\Business\ContactController@update'));
Route::get('delete/{id}', array('as' => 'teamLead.business.contact.delete', 'uses' => 'Admin\TeamLead\Business\ContactController@destroy'));

Route::get('/report/export', array('as' => 'teamLead.business.contact.exportCsv', 'uses' => 'Admin\TeamLead\Business\ContactController@exportCsv'));


});

 Route::group(['prefix' => 'teamLead/renewals'], function () {

    Route::any('/', array('as' => 'teamLead.renewal.show', 'uses' => 'Admin\TeamLead\PolicyController@renewals'));
    Route::get('export', array('as' => 'teamLead.renewal.exportCsv', 'uses' => 'Admin\TeamLead\PolicyController@exportCsv'));

  });

    ///////////////////////////////// Staff Assign Leads Route Prefix /////////////////////////////////
    //Route::any('/data', array('as' => 'staff.dashboard.show', 'uses' => 'Admin\Staff\DashboardController@index'));
   
    Route::group(['prefix' => 'staff/tasks'], function () {
      Route::any('', array('as' => 'staff.tasks.show', 'uses' => 'Admin\Staff\TaskController@index'));
      Route::get('create', array('as' => 'staff.tasks.create', 'uses' => 'Admin\Staff\TaskController@create'));
      Route::post('store', array('as' => 'staff.tasks.store', 'uses' => 'Admin\Staff\TaskController@store'));
      Route::get('edit/{id}', array('as' => 'staff.tasks.edit', 'uses' => 'Admin\Staff\TaskController@show'));
      Route::post('update/{id}', array('as' => 'staff.tasks.update', 'uses' => 'Admin\Staff\TaskController@update'));
      Route::get('delete/{id}', array('as' => 'staff.tasks.delete', 'uses' => 'Admin\Staff\TaskController@destroy'));
      Route::get('notes/{id}', array('as' => 'staff.tasks.notes.show', 'uses' => 'Admin\Staff\TaskController@ShowNotesdetails'));
      Route::get('/export', array('as' => 'staff.tasks.exportCsv', 'uses' => 'Admin\Staff\TaskController@exportCsv'));


      Route::group(['prefix' => '/myTasks'], function () {

        Route::any('/', array('as' => 'staff.mytasks.show', 'uses' => 'Admin\Staff\TaskController@mytasks'));
        Route::get('details/{id}', array('as' => 'staff.mytasks.detail', 'uses' => 'Admin\Staff\TaskController@details'));
        Route::post('details/update/{id}', array('as' => 'staff.mytasks.detail.update', 'uses' => 'Admin\Staff\TaskController@detailUpdate'));
        Route::get('download/{id}', array('as' => 'staff.mytasks.detail.download', 'uses' => 'Admin\Staff\TaskController@getDownload'));
        Route::get('/export', array('as' => 'staff.mytasks.exportCsv', 'uses' => 'Admin\Staff\TaskController@exportCsv1'));
      });
      

    });

 Route::group(['prefix' => 'staff/call/activities'], function () {
    Route::any('', array('as' => 'staff.reports.callactivity.show', 'uses' => 'Admin\Staff\Call\CallActivityController@index'));
    Route::get('create', array('as' => 'staff.reports.callactivity.create', 'uses' => 'Admin\Staff\Call\CallActivityController@create'));
    Route::post('store', array('as' => 'staff.reports.callactivity.store', 'uses' => 'Admin\Staff\Call\CallActivityController@store'));
    Route::get('edit/{id}', array('as' => 'staff.reports.callactivity.edit', 'uses' => 'Admin\Staff\Call\CallActivityController@show'));
    Route::post('update/{id}', array('as' => 'staff.reports.callactivity.update', 'uses' => 'Admin\Staff\Call\CallActivityController@update'));
    
    Route::get('delete/{id}', array('as' => 'staff.reports.callactivity.delete', 'uses' => 'Admin\Staff\Call\CallActivityController@destroy'));

    Route::any('getBrokers', array('as' => 'staff.reports.callactivity.brokers', 'uses' => 'Admin\Staff\Call\CallActivityController@getBrokers'));

     Route::get('report/export/', array('as' => 'staff.reports.callactivity.export', 'uses' => 'Admin\Staff\Call\CallActivityController@exportCSV'));
});

    Route::group(['prefix' => 'staff/assigned'], function () {
      Route::any('/', array('as' => 'staff.leads.assignedLeads', 'uses' => 'Admin\Staff\LeadController@assignedLeads'));
    });

    Route::group(['prefix' => 'staff/renewals'], function () {

        Route::any('/', array('as' => 'staff.renewal.show', 'uses' => 'Admin\Staff\PolicyController@renewals'));

         Route::get('export', array('as' => 'staff.renewal.exportCsv', 'uses' => 'Admin\Staff\PolicyController@exportCsv'));

        });
Route::get('report/export', array('as' => 'staff.leads.exportCsv', 'uses' => 'Admin\Staff\LeadController@exportCsv'));

    Route::group(['prefix' => 'staff/leads'], function () {

    Route::any('/', array('as' => 'staff.leads.show', 'uses' => 'Admin\Staff\LeadController@index'));
    Route::get('create', array('as' => 'staff.leads.create', 'uses' => 'Admin\Staff\LeadController@create'));
    Route::post('save', array('as' => 'staff.leads.save', 'uses' => 'Admin\Staff\LeadController@store'));
    Route::get('edit/{id}', array('as' => 'staff.leads.edit', 'uses' => 'Admin\Staff\LeadController@show'));
    Route::post('lead/update/{id}', array('as' => 'staff.leads.update', 'uses' => 'Admin\Staff\LeadController@update'));
    Route::get('details/{id}', array('as' => 'staff.leads.details', 'uses' => 'Admin\Staff\LeadController@details'));
    Route::get('leads/delete/{id}', array('as' => 'staff.leads.delete', 'uses' => 'Admin\Staff\LeadController@destroy'));
    Route::any('getCompanies', array('as' => 'staff.leads.get.companies', 'uses' => 'Admin\Staff\LeadController@getCompanies'));
    Route::post('{id}/sales/lookup-debit-note', array(
        'as'   => 'staff.leads.sales.lookup',
        'uses' => 'Admin\Staff\LeadController@lookupDebitNote'
    ));

    Route::post('{id}/sales/convert-from-debit-note', array(
        'as'   => 'staff.leads.sales.convert',
        'uses' => 'Admin\Staff\LeadController@convertFromDebitNote'
    ));
   

    ///////////////////////////////////////Call Activity Routes////////////////////////////////////

    Route::any('calls', array('as' => 'staff.leads.call.show', 'uses' => 'Admin\Staff\CallActivityController@index'));
    /*Route::get('call/create/{id}', array('as' => 'staff.leads.call.create', 'uses' => 'Admin\Staff\CallActivityController@create'));*/ 
    Route::post('store', array('as' => 'staff.leads.call.store', 'uses' => 'Admin\Staff\CallActivityController@store'));
    Route::post('convert', array('as' => 'staff.leads.call.convert', 'uses' => 'Admin\Staff\CallActivityController@convert'));
    Route::get('call/edit/{id}', array('as' => 'staff.leads.call.edit', 'uses' => 'Admin\Staff\CallActivityController@show'));
    Route::post('update/{id}', array('as' => 'staff.leads.call.update', 'uses' => 'Admin\Staff\CallActivityController@update'));
    Route::get('delete/{id}', array('as' => 'staff.leads.call.delete', 'uses' => 'Admin\Staff\CallActivityController@destroy'));

     Route::get('report/export/', array('as' => 'staff.leads.call.export', 'uses' => 'Admin\Staff\CallActivityController@exportCSV'));
   ///////////////////////////////////////////////////////////////////////////////////////////////////// 
    Route::any('opportunity', array('as' => 'staff.opportunity.show', 'uses' => 'Admin\Staff\OpportunityController@index'));
    Route::get('opportunity/create', array('as' => 'staff.opportunity.create', 'uses' => 'Admin\Staff\OpportunityController@create'));
    Route::post('opportunity/store', array('as' => 'staff.opportunity.store', 'uses' => 'Admin\Staff\OpportunityController@store'));
    Route::get('opportunity/edit/{id}', array('as' => 'staff.opportunity.edit', 'uses' => 'Admin\Staff\OpportunityController@show'));
    Route::post('opportunity/update/{id}', array('as' => 'staff.opportunity.update', 'uses' => 'Admin\Staff\OpportunityController@update'));
    Route::get('opportunity/delete/{id}', array('as' => 'staff.opportunity.delete', 'uses' => 'Admin\Staff\OpportunityController@destroy'));

    Route::get('opportunities/export', array('as' => 'staff.opportunity.exportCsv', 'uses' => 'Admin\Staff\OpportunityController@exportCsv'));

   ///////////////////////////////////////////////////////////////////////////////////////////////////// 
    Route::any('sales', array('as' => 'staff.sales.show', 'uses' => 'Admin\Staff\SaleController@index'));
    Route::any('crm/sales', array('as' => 'staff.crm.sales.show', 'uses' => 'Admin\Staff\SaleController@crmsales'));

    Route::get('sales/create/{id}', array('as' => 'staff.sales.create', 'uses' => 'Admin\Staff\SaleController@create'));
    Route::post('sales/store', array('as' => 'staff.sales.store', 'uses' => 'Admin\Staff\SaleController@store'));
    Route::get('sales/edit/{id}', array('as' => 'staff.sales.edit', 'uses' => 'Admin\Staff\SaleController@show'));
    Route::post('sales/update/{id}', array('as' => 'staff.sales.update', 'uses' => 'Admin\Staff\SaleController@update'));
    Route::get('sales/delete/{id}', array('as' => 'staff.sales.delete', 'uses' => 'Admin\Staff\SaleController@destroy'));
    Route::any('sales/agency', array('as' => 'staff.sales.agency', 'uses' => 'Admin\Staff\SaleController@getAgency'));
    Route::get('sales/export', array('as' => 'staff.sales.exportCsv', 'uses' => 'Admin\Staff\SaleController@exportCsv'));
    Route::get('sales/crm/export', array('as' => 'staff.crm.sales.exportCsv', 'uses' => 'Admin\Staff\SaleController@exportCsv1'));

    ///////////////////////////////////////////////////////////////////////////////////////////////////// 
    Route::any('/accounts', array('as' => 'staff.accounts.show', 'uses' => 'Admin\Staff\AccountController@index'));
    Route::get('accounts/edit/{id}', array('as' => 'staff.accounts.edit', 'uses' =>'Admin\Staff\AccountController@show'));

    Route::post('accounts/convert/{id}', array('as' => 'staff.accounts.convert', 'uses' => 'Admin\Staff\AccountController@convertToOpportunity'));
    Route::get('accounts/delete/{id}', array('as' => 'staff.accounts.delete', 'uses' => 'Admin\Staff\AccountController@destroy'));
  Route::get('accounts/report/export/', array('as' => 'staff.accounts.export', 'uses' => 'Admin\Staff\AccountController@exportCSV'));
     
    Route::any('/contacts', array('as' => 'staff.contacts.show', 'uses' => 'Admin\Staff\ContactController@index'));
    Route::get('contacts/report/export/', array('as' => 'staff.contacts.export', 'uses' => 'Admin\Staff\ContactController@exportCSV'));

 });
   ///////////////////////////////// End Staff Assign Leads Route Prefix /////////////////////////////////


    
   




     });           
     
     });
    
    }
  }