<?php

namespace App\Helpers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use App\Mail\SendMail;
use App\Models\Sale;
use App\Models\Lead;
use App\Models\Account;
use App\Models\Task;
use App\Models\User;
use DB;
use Cookie;
use Auth;

class EmailHelper
{
    
     public static function sendEmailToUser($request, $clo_name = null)
     {
        // Safe getter for mixed $request types (Request, Fluent, stdClass, array)
        $get = function ($key, $default = null) use ($request) {
            // Illuminate Request
            if ($request instanceof \Illuminate\Http\Request) {
                return $request->input($key, $default);
            }
            // Array payload
            if (is_array($request)) {
                return array_key_exists($key, $request) ? $request[$key] : $default;
            }
            // Generic object (Fluent/stdClass)
            if (is_object($request)) {
                // Prefer data_get if available
                if (function_exists('data_get')) {
                    return data_get($request, $key, $default);
                }
                return property_exists($request, $key) ? $request->{$key} : $default;
            }
            return $default;
        };
    
        // --- Normalize recipients to ARRAY ---
        $rawEmails = $get('email'); // can be array|string|null
        $emails = [];
    
        if (is_array($rawEmails)) {
            $emails = $rawEmails;
        } elseif (is_string($rawEmails)) {
            // Try JSON first
            $decoded = json_decode($rawEmails, true);
            if (json_last_error() === JSON_ERROR_NONE && is_array($decoded)) {
                $emails = $decoded;
            } else {
                // Fallback: split by comma/space
                $parts = preg_split('/[,\s]+/', $rawEmails, -1, PREG_SPLIT_NO_EMPTY);
                $emails = $parts ?: [$rawEmails];
            }
        }
    
        // Trim and remove empties/invalids
        $emails = array_values(array_filter(array_map('trim', $emails)));
    
        if (empty($emails)) {
            // No valid recipients -> nothing to send
            return false;
        }
    
        // --- Build mail data (keep keys the helper/view expects) ---
        $data = [
            'insurance_no'         => $get('insurance_no'),
            'client_code'          => $get('client_code'),
            'agency'               => $get('agency'),
            'insurance_class'      => $get('insurance_class'),
            'insurance_type'       => $get('insurance_type'),
            'business_type'        => $get('business_type'),
            'insurance_group'      => $get('insurance_group'),
            'reference'            => $get('reference'),
            'currency'             => $get('currency'),
            'rate'                 => $get('rate'),
            'issuance_date'        => $get('issuance_date'),
            'term'                 => $get('term'),
            'cover_period_from'    => $get('cover_period_from'),
            'cover_period_to'      => $get('cover_period_to'),
            'limit_of_exposure'    => $get('limit_of_exposure'),
            'insurance_branch'     => $get('insurance_branch'),
            'business_location'    => $get('business_location'),
            'geographical_cover'   => $get('geographical_cover'),
            'occupational_exposure'=> $get('occupational_exposure'),
            'clo_name'             => $clo_name ?? $get('clo_name'),
            'user_id'              => $get('user_id'),
            'insurance_status'     => $get('insurance_status'),
            // 'to' will be set per recipient below
        ];
    
        $fromTitle = 'VKA CRM Team';
        $from      = 'no_reply@veritaskapital.com';
        $subject   = 'Lead Converted To Sales';
        $view      = 'emails.promotion.approvel_and_rejection_notification_to_partner';
    
        $allOk = true;
    
        foreach ($emails as $e) {
            if ($e === '') { continue; }
            $data['to'] = $e;
    
            $param = [
                'subject' => $subject,
                'from'    => ['name' => $fromTitle, 'address' => $from],
                'view'    => $view,
                'data'    => $data,
            ];
    
            try {
                \Mail::to($e)->send(new \App\Mail\SendMail($param));
            } catch (\Throwable $ex) {
                \Log::error('sendEmailToUser: failed to send', [
                    'to' => $e,
                    'error' => $ex->getMessage(),
                ]);
                $allOk = false; // at least one failed
            }
        }
    
        return $allOk;
    }


    


     public static function leadConvertToSale($leadID){
        $Lead = Lead::where('id', '=', $leadID)->first();
        $Lead->status = 'Sale';
        $Lead->save();
        return true;
     }

     public static function createAccount($request){
     //dd($request);
      $checkExistingLead = Account::where('lead_id','=',$request->lead_id)->exists();
      
      if($checkExistingLead != true){
      $Account = new Account;
      $Account->user_id = $request->user_id;
      $Account->clo_id = $request->client_code;
      $Account->account_name = Lead::where('id','=',$request->lead_id)->pluck('firstname','lastname')->first();
      $Account->assigned_by_user_id = Sale::where('user_id','=',$request->user_id)->pluck('assigned_by_user_id')->first();
      
      $Account->lead_id = $request->lead_id;
      $Account->insurance_id = $request->insurance_id;
      $Account->insurance_name = $request->insurance_name;
      $Account->expire = $request->expire;
      $Account->price = $request->price;
      $Account->insurance_no = $request->insurance_no;
      $Account->client_code = $request->client_code;
      $Account->agency = $request->agency;      
      $Account->insurance_class = $request->insurance_class;
      $Account->insurance_type = $request->insurance_type;
      $Account->business_type = $request->business_type;
      $Account->insurance_group = $request->insurance_group;
      $Account->reference = $request->reference;
      $Account->currency = $request->currency;
      $Account->rate = $request->rate;
      $Account->issuance_date = $request->issuance_date;
      $Account->term = $request->term;
      $Account->cover_period_from = $request->cover_period_from;
      $Account->cover_period_to = $request->cover_period_to;
      $Account->limit_of_exposure = $request->limit_of_exposure;
      $Account->insurance_branch = $request->insurance_branch;
      $Account->business_location = $request->business_location;
      $Account->geographical_cover = $request->geographical_cover;
      $Account->occupational_exposure = $request->occupational_exposure;
      $Account->insurance_status = $request->insurance_status;    
      $Account->save();
      return true;
    }

     }
        

    public static function sendEmailToTaskUser($id){  
      
      $user_id = Task::where('id','=',$id)->pluck('user_id')->first();
      $user = User::where('id','=',$user_id)->first();
    
      $data = array(
              'firstname' => $user->name,
              'lastname' => $user->lastname,
              'username' => $user->username,
              'email' => $user->email
              
            );
    
    
                $fromTitle = 'VKA CRM Team';
                $from =  'no_reply@veritaskapital.com';
    
                $subject = 'New Task Assigned';
                $email = $data['email'];
                $to = $email;
                $toTitle = 'New Task';
                $data['to'] = $to;
                $param = [
                    'subject' => $subject,
                    'from' => ['name' => $fromTitle, 'address' => $from],
                    'view' => 'emails.task_assign_email_template',
                    'data' => $data
                ];
                $to = ['name' => $toTitle, 'email' => $to];
                $to = (Object)$to;
                 
                  Mail::to($data['to'])->send(new SendMail($param));
    
    }
    
    
    public static function sendEmailToTaskAssigner($id,$status){  
      $user   = User::where('id','=',$id)->first();
    
      $data = array(
              'firstname' => $user->name,
              'lastname' => $user->lastname,
              'username' => $user->username,
              'email' => $user->email,
              'status'=>$status
              
            );
    
    
                $fromTitle = 'VKA CRM Team';
                $from =  'no_reply@veritaskapital.com';
    
                $subject = 'Task replied';
                $email = $data['email'];
                $to = $email;
                $toTitle = 'Task replied';
                $data['to'] = $to;
                $param = [
                    'subject' => $subject,
                    'from' => ['address' => $from,'name' => $fromTitle],
                    'view' => 'emails.task_assign_reply_email_template',
                    'data' => $data
                ];
                $to = ['name' => $toTitle, 'email' => $to];
                $to = (Object)$to;
                 
                  Mail::to($data['to'])->send(new SendMail($param));
    
    }
        
}